/**
 * @(#)DownloadDialog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-3 : _E[h_CAO
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/09/06
 */
package jp.co.nri.rid.environment;

import java.net.*;
import java.awt.*;

import java.awt.event.ActionEvent;

import javax.swing.JComponent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.IZApp;

import jp.co.iti.fagot.ui.UDialog;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.rid.RidMIT;
import jp.co.nri.Ridual;

/**
 * _E[h_CAO̕\
 */
public class DownloadDialog {

	//## _CAO ###################################################
	/**
	 * _E[h_CAO̕\
	 */
    public boolean show() {
	IZApp app = ZApp.getTheApp();
	ZResource res = app.getResource();
	mDialog = new UDialog(app,"download");
	
	// _CAO̕\
//	mDialog.setComponent( panel,false );
	mDialog.setComponent( getContentComponent(),false );
	mDialog.setControlPanel("ok cancel");

	// ftHg{^̐ݒ
	mDialog.getRootPane().setDefaultButton(mDialog.getOKButton());

	boolean bRet = mDialog.doModal();

	if ( bRet ) {
		String szURL = mURL.getText();
		if ( szURL != null && szURL.length()==0 ) {
			szURL = null;
		}
		res.putString("download.url",szURL);
		
		if(mTopZoneURL.isSelected() && (null != szURL)){
			try{
				URL url = new URL(szURL);
				
				String path = url.getPath();
				
				if(!path.endsWith("/")){
					int ix = path.lastIndexOf('/');
					if(0 <= ix)	path = path.substring(0, ix);
				}
				
				Ridual.setTopZoneURL(
					new URL(url.getProtocol(),
							url.getHost(),
							url.getPort(),
							path
					).toExternalForm()
				);
				
			}catch(MalformedURLException e){ Ridual.setTopZoneURL(szURL); }
		}
		
        res.putBoolean("download.resource", mResource.isSelected());
        res.putBoolean("download.topzoneurl", mTopZoneURL.isSelected());

		String szHost = mHost.getText();
		if ( szHost != null && szHost.length()==0 ) {
			szHost = null;
		}
		res.putString("download.proxy.host",szHost);

		String szPort = mPort.getText();
		if ( szPort != null && szPort.length()==0 ) {
			szPort = null;
		}
		res.putString("download.proxy.port",szPort);

		String szUser = mUser.getText();
		if ( szUser == null || szUser.length()==0 ) {
			ZInstance.prop().remove("download.proxy.user");
		} else {
			ZInstance.prop().setProperty("download.proxy.user",szUser);
		}

		String szPass = new String(mPass.getPassword());
		if ( szPass.length()==0 ) {
			ZInstance.prop().remove("rid.perform");
		} else {
			ZInstance.prop().setProperty("rid.perform",szPass);
		}
	}
	return bRet ;
	}


	private JComponent getContentComponent(){
	ZResource res = ZApp.getTheApp().getResource();
	
	// plCAEg̍쐬
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints cns = new GridBagConstraints();
	cns.insets  = new Insets(10,10,0,10) ;
	JPanel panel = new JPanel(new BorderLayout(4, 4));
	panel.setBorder(new EmptyBorder(8, 8, 0, 8));
	
	JPanel pnl = new JPanel(new BorderLayout());
	
	// PsځFURL
	pnl.add(new JLabel(res.getString("msg.download.url")), BorderLayout.WEST);
	
	mURL = new JTextField(30);
	String szURL = res.getString("download.url");
	if ( szURL != null ) {
		mURL.setText( szURL );
	}
	pnl.add(mURL, BorderLayout.CENTER);
	panel.add(pnl, BorderLayout.NORTH);
	
	JTabbedPane tab = new JTabbedPane();
	panel.add(tab, BorderLayout.CENTER);
	
	pnl = new JPanel(new FlowLayout(FlowLayout.LEFT));
	tab.add("option", pnl);
	
	// QsځF\[X
	mResource = new JCheckBox(res.getString("msg.download.resource"), res.getBoolean("download.resource"));
	pnl.add(mResource);
	
	// TopZone URL
	mTopZoneURL = new JCheckBox(res.getString("msg.download.topzoneurl"), res.getBoolean("download.topzoneurl"));
	pnl.add(mTopZoneURL);
	
	
	pnl = new JPanel(gridbag);
	tab.add("proxy", pnl);
	
	// RsځFProxy zXg
	cns.gridwidth = GridBagConstraints.RELATIVE;
	cns.weightx = 0.0;
	pnl.add(new JLabel(res.getString("msg.download.proxy.host")),cns);

	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	mHost = new JTextField(30) ;
	String szHost = res.getString("download.proxy.host");
	if ( szHost != null ) {
		mHost.setText( szHost );
	}
	pnl.add(mHost,cns);

	// SsځFProxy |[g
	cns.gridwidth = GridBagConstraints.RELATIVE;
	cns.weightx = 0.0;
	pnl.add(new JLabel(res.getString("msg.download.proxy.port")),cns);

	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	mPort = new JTextField(30) ;
	String szPort = res.getString("download.proxy.port");
	if ( szPort != null ) {
		mPort.setText( szPort );
	}
	pnl.add(mPort,cns);

	// TsځFProxy [U
	cns.gridwidth = GridBagConstraints.RELATIVE;
	cns.weightx = 0.0;
	pnl.add(new JLabel(res.getString("msg.download.proxy.user")),cns);

	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	mUser = new JTextField(30) ;
//	String szUser = res.getString("download.proxy.user");
//	if ( szUser != null ) {
//		mUser.setText( szUser );
//	}
	pnl.add(mUser,cns);

	// UsځFProxy pX[h
	cns.gridwidth = GridBagConstraints.RELATIVE;
	cns.weightx = 0.0;
	pnl.add(new JLabel(res.getString("msg.download.proxy.pass")),cns);

	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	mPass = new JPasswordField(30) ;
//	String szPass = res.getString("rid.perform");
//	szPass = RidMIT.decodeMIT(szPass);
//	if ( szPass != null ) {
//		mPass.setText( szPass );
//	}
	pnl.add(mPass,cns);
	
	return panel;
	}
	
	
/*

	private JComponent getContentComponent(){
	ZResource res = ZApp.getTheApp().getResource();
	
	// plCAEg̍쐬
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints cns = new GridBagConstraints();
	cns.insets  = new Insets(10,10,0,10) ;
	JPanel panel = new JPanel();
	panel.setLayout( gridbag );

	// PsځFURL
	cns.fill = GridBagConstraints.BOTH;
	cns.weightx = 0.0;
	panel.add(new JLabel(res.getString("msg.download.url")),cns);

	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	mURL = new JTextField(30);
	String szURL = res.getString("download.url");
	if ( szURL != null ) {
		mURL.setText( szURL );
	}
	panel.add(mURL,cns);

	// QsځF\[X
	cns.gridwidth = GridBagConstraints.RELATIVE;
	cns.weightx = 0.0;
	panel.add(new JLabel(res.getString("msg.download.resource")),cns);

	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	mResource = new JCheckBox();
	boolean bResource = res.getBoolean("download.resource");
	mResource.setSelected( bResource );
	panel.add(mResource,cns);

	// RsځFProxy zXg
	cns.gridwidth = GridBagConstraints.RELATIVE;
	cns.weightx = 0.0;
	panel.add(new JLabel(res.getString("msg.download.proxy.host")),cns);

	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	mHost = new JTextField(30) ;
	String szHost = res.getString("download.proxy.host");
	if ( szHost != null ) {
		mHost.setText( szHost );
	}
	panel.add(mHost,cns);

	// SsځFProxy |[g
	cns.gridwidth = GridBagConstraints.RELATIVE;
	cns.weightx = 0.0;
	panel.add(new JLabel(res.getString("msg.download.proxy.port")),cns);

	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	mPort = new JTextField(30) ;
	String szPort = res.getString("download.proxy.port");
	if ( szPort != null ) {
		mPort.setText( szPort );
	}
	panel.add(mPort,cns);

	// TsځFProxy [U
	cns.gridwidth = GridBagConstraints.RELATIVE;
	cns.weightx = 0.0;
	panel.add(new JLabel(res.getString("msg.download.proxy.user")),cns);

	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	mUser = new JTextField(30) ;
//	String szUser = res.getString("download.proxy.user");
//	if ( szUser != null ) {
//		mUser.setText( szUser );
//	}
	panel.add(mUser,cns);

	// UsځFProxy pX[h
	cns.gridwidth = GridBagConstraints.RELATIVE;
	cns.weightx = 0.0;
	panel.add(new JLabel(res.getString("msg.download.proxy.pass")),cns);

	cns.gridwidth = GridBagConstraints.REMAINDER;
	cns.weightx = 10.0;
	mPass = new JPasswordField(30) ;
//	String szPass = res.getString("rid.perform");
//	szPass = RidMIT.decodeMIT(szPass);
//	if ( szPass != null ) {
//		mPass.setText( szPass );
//	}
	panel.add(mPass,cns);
	
	return panel;
	}
*/	
	
	//## Agr[g ###############################################
	/**
	 * _CAO
	 */
	protected UDialog mDialog = null;

	/**
	 * _E[hURL
	 */
	protected JTextField mURL = null;

	/**
	 * _E[hURL
	 */
	protected JCheckBox mResource = null;

	/**
	 * ProxyzXg
	 */
	protected JTextField mHost = null;

	/**
	 * Proxy|[g
	 */
	protected JTextField mPort = null;

	/**
	 * Proxy[U
	 */
	protected JTextField mUser = null;

	/**
	 * ProxypX[h
	 */
	protected JPasswordField mPass = null;

	/**
	 * TopZone URLݒ
	 */
	private JCheckBox mTopZoneURL = null;
}
