/*
 * @(#)EnvCheckBoxText.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : `FbN{bNXt̓TEXT̈̍쐬
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/01/29
 */
package jp.co.nri.rid.environment;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;

/**
  *`FbN{bNXt̓TEXT̈̍쐬
  **/
public class EnvCheckBoxText extends JPanel {

    protected JPanel      mPanel    = null;
    protected JCheckBox   mCheckBox = null;
    protected JTextField  mText     = null;

    /**
      *  `FbN{bNXt̓TEXT̈̍쐬
      */
    public EnvCheckBoxText(boolean selected, String value) {

        // pl̐
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints gbc = new GridBagConstraints();

        // CheckBox̐
        mCheckBox = new JCheckBox();
        setSelected(selected); 
        mPanel.add(mCheckBox);

        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.weightx = 0.0;
        gbc.gridx   = 0;
        mLayout.setConstraints(mCheckBox, gbc);


        // TextField̐
        mText = new JTextField(value);
        mPanel.add(mText);

        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0;
        gbc.gridx   = 1;
        mLayout.setConstraints(mText, gbc);

    }


    /**
      * JPanel̎擾
      */
    public JPanel getPanel(){
        return mPanel;
    }


    /**
      * JCheckBox̎擾
      */
    public JCheckBox getCheckBox(){
        return mCheckBox;
    }


    /**
      * JCheckBox̏Ԃݒ
      */
    public void setSelected(boolean selected) {
        mCheckBox.setSelected(selected);
    }


    /**
      * JCheckBox̏Ԃ擾
      */
    public boolean getSelected() {
        return mCheckBox.isSelected();
    }


    /**
      * eLXgtB[h̎擾
      */
    public JTextField getTextField() {
        return mText;
    }

    /**
      * l̐ݒ
      * @param szValue ݒ蕶
      */
      public void setString( String szValue ){
          mText.setText( szValue );
      }

      /**
        * l̎擾
        */
      public String getString(){
          String szTmp = mText.getText();
          if ( szTmp == null || szTmp.equals("") ) {  return null;  }
          return szTmp;
      }



}
