/*
 * @(#)ExistDialog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X F݃`FbN_CAO
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/02/06
 */
package jp.co.nri.rid.environment;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.io.File;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;


/**
 * ݃`FbN_CAO
 */

public class ExistDialog {

    /** rid.ignore.prefixvpeB  **/
    final static public String IGNORE_PREFIX      = "rid.ignore.prefix";
    /** exist.pagevpeB  **/
    final static public String EXIST_PAGE         = "exist.page";
    /** exist.resourcevpeB  **/
    final static public String EXIST_RESOURCE     = "exist.resource";
    /** exist.documentvpeB  **/
    final static public String EXIST_DOCUMENT     = "exist.document";

    /** msg.exist.titlevpeB  **/
    final static public String MSG_EXIST_TITLE    = "msg.exist.title";
    /** msg.exist.ignorevpeB  **/
    final static public String MSG_EXIST_IGNORE   = "msg.exist.ignore";
    /** msg.exist.ignorevpeB  **/
    final static public String MSG_EXIST_EXIST    = "msg.exist.exist";
    /** msg.exist.pagevpeB  **/
    final static public String MSG_EXIST_PAGE     = "msg.exist.page";
    /** msg.exist.resourcevpeB  **/
    final static public String MSG_EXIST_RESOURCE = "msg.exist.resource";
    /** msg.exist.documentvpeB  **/
    final static public String MSG_EXIST_DOCUMENT = "msg.exist.document";

    /** Cpl              **/
    protected JPanel      mPanel          = null;
    /** IgnoreL[                **/
    protected JTextField  mIgnorePrefix   = null;
    /** JCheckBoxiy[Wj       **/
    protected JCheckBox   mExistPage      = null;
    /** JCheckBoxi\[Xj     **/
    protected JCheckBox   mExistResource  = null;
    /** JCheckBoxihLgj **/
    protected JCheckBox   mExistDocument  = null;

    /**
      * ftHgRXgN^
      */
      public ExistDialog() {  }

    /**
      * ݃`FbN_CAO
      *
      * @return boolean     {^̏true(OK)/false(Cancel)
      */
    public boolean show() {

        ZResource res = ZApp.getTheApp().getResource();
        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog gdlg = new EnvDialog(frame, res.getString(MSG_EXIST_TITLE));

        //CR|[lg
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill       = GridBagConstraints.BOTH;
        gbc.insets     = new Insets(10,10,10,10) ;
        //public Insets(int top, int left, int bottom, int right)

        //x
        gbc.gridy      = 0;
        gbc.gridx      = 0;
        JLabel label = new JLabel(res.getString(MSG_EXIST_IGNORE));
        mLayout.setConstraints(label, gbc);
        mPanel.add( label );

        //IgnorePrefix
        gbc.gridy      = 0;
        gbc.gridx      = 1;
        gbc.gridwidth  = 3;
        mIgnorePrefix = createIgnorePrefix();
        mLayout.setConstraints(mIgnorePrefix, gbc);
        mPanel.add( mIgnorePrefix );


        //x
        gbc.gridy      = 1;
        gbc.gridx      = 0;
        gbc.gridwidth  = 1;
        gbc.gridheight = 1;
        label = new JLabel(res.getString(MSG_EXIST_EXIST));
        mLayout.setConstraints(label, gbc);
        mPanel.add( label );


        //y[W`FbN{bNX
        gbc.gridy      = 1;
        gbc.gridx      = 1;
        mExistPage = createExistCheckBox(res.getString(MSG_EXIST_PAGE), EXIST_PAGE);
        mLayout.setConstraints(mExistPage, gbc);
        mPanel.add( mExistPage );


        //\[X`FbN{bNX
        gbc.gridy      = 1;
        gbc.gridx      = 2;
        mExistResource = createExistCheckBox(res.getString(MSG_EXIST_RESOURCE), EXIST_RESOURCE);
        mLayout.setConstraints(mExistResource, gbc);
        mPanel.add( mExistResource );

        //hLg`FbN{bNX
        gbc.gridy      = 1;
        gbc.gridx      = 3;
        mExistDocument = createExistCheckBox(res.getString(MSG_EXIST_DOCUMENT), EXIST_DOCUMENT);
        mLayout.setConstraints(mExistDocument, gbc);
        mPanel.add( mExistDocument );


        // [CR|[lg][OK][CENCEL]
        gdlg.setControlPanel(mPanel);

        //_CAO\i[_j
        gdlg.doModal();

        // []{^ꂽꍇɕύX
        boolean ret = gdlg.isOK();
        if (ret){
            setExist();
            
        }   
        return ret;
    }


    /**
      * ignoreL[JTextField𐶐
      *
      * @return JTextField
      */
    private JTextField createIgnorePrefix() {
        ZResource res = ZApp.getTheApp().getResource();
        String  ignore_prefix = res.getString(IGNORE_PREFIX);
        JTextField text = new JTextField(ignore_prefix);
        return text;
    }

    /**
      * ignoreL[̕擾
      *
      * @return String
      */
    private String getIgnorePrefix(){
        String szTmp = mIgnorePrefix.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }

    /**
      * ݃`FbÑ`FbN{bNX쐬
      *
      * @param  String      label         x
      * @param  String      resource      \[X
      * @return JCheckBox
      */
    private JCheckBox createExistCheckBox(String label, String resource) {
        ZResource res = ZApp.getTheApp().getResource();
        boolean selected = res.getBoolean(resource);
        JCheckBox chk = new JCheckBox(label);
        chk.setSelected(selected);
        return chk;
    }

    /**
      * vpeBݒ
      *
      * @return void
      */
    private void setExist() {

        ZResource res = ZApp.getTheApp().getResource();

        /* [gnore.prefix]ݒ */
        res.putString(IGNORE_PREFIX, getIgnorePrefix() );

        /* [exist.page]ݒ */
        res.putBoolean(EXIST_PAGE, mExistPage.isSelected());

        /* [exist.resource]ݒ */
        res.putBoolean(EXIST_RESOURCE, mExistResource.isSelected());

        /* [exist.document]ݒ */
        res.putBoolean(EXIST_DOCUMENT, mExistDocument.isSelected());

    }

}
