/*
 * @(#)SnapshotDialog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : XibvVbg_CAO
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/03/13
 */
package jp.co.nri.rid.environment;

import java.awt.Insets;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZResource;

/**
 * XibvVbg_CAO
 */

public class SnapshotDialog {

    /** snapshot.commentvpeB̒`      **/
    final static public String SNAPSHOT_COMMENT     = "snapshot.comment";
    /** msg.snapshot.titlevpeB̒`    **/
    final static public String MSG_SNAPSHOT_TITLE   = "msg.snapshot.title";
    /** msg.snapshot.messagevpeB̒`  **/
    final static public String MSG_SNAPSHOT_MESSAGE = "msg.snapshot.message";
    /** msg.snapshot.commenvpeB̒`   **/
    final static public String MSG_SNAPSHOT_COMMENT = "msg.snapshot.comment";

    /** _CAO  **/
    protected EnvDialog   gdlg     = null;
    /** pl      **/
    protected JPanel      mPanel   = null;
    /** Rg    **/
    protected JTextField  mComment = null;

    /**
      * ftHgRXgN^
      */
      public SnapshotDialog() {  }

    /**
      * XibvVbg_CAO
      *
      * @return boolean     {^̏true(OK)/false(Cancel)
      */
    public boolean show() {

        ZResource res = ZApp.getTheApp().getResource();

        //_CAO
        JFrame frame = (JFrame)ZApp.getTheApp().getFrame();
        gdlg = new EnvDialog(frame, res.getString(MSG_SNAPSHOT_TITLE));

        //CR|[lg
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints label_gbc = createLabelConstraints();
        GridBagConstraints compo_gbc = createComponentConstraints();

        //bZ[W
        label_gbc.gridy      = 0;
        label_gbc.gridx      = 0;
        label_gbc.gridwidth  = 2;
        label_gbc.gridheight = 1;
        JLabel label = new JLabel(res.getString(MSG_SNAPSHOT_MESSAGE));
        mLayout.setConstraints(label, label_gbc);
        mPanel.add( label );

        //Rg
        label_gbc.gridy      = 1;
        label_gbc.gridx      = 0;
        label_gbc.gridwidth  = 1;
        label_gbc.gridheight = 1;
        label = new JLabel(res.getString(MSG_SNAPSHOT_COMMENT));
        mLayout.setConstraints(label, label_gbc);
        mPanel.add( label );

        //RgGA
        compo_gbc.gridy      = 1;
        compo_gbc.gridx      = 1;
        mComment = new JTextField("");
/*        mComment.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { setComment(); }
            }
        );
*/
        mLayout.setConstraints(mComment, compo_gbc);
        mPanel.add( mComment );

        // [CR|[lg][OK][CENCEL]
        gdlg.setControlPanel(mPanel);

        //_CAO\i[_j
        gdlg.doModal();

        // [OK]{^ꂽꍇɕύX
        boolean ret = gdlg.isOK();
        if (ret){
            setComment();
        }   
        return ret;
    }

    /**
      * snapshot.commentvpeBɃRgݒ肷
      *
      * @return void
      */
    private void setComment(){
        ZResource res = ZApp.getTheApp().getResource();
        res.putString(SNAPSHOT_COMMENT, getComment());
    }

    /**
      * RgGA̕擾
      *
      * @return String  Rg
      */
    private String getComment(){
        String szTmp = mComment.getText();
        if ( szTmp == null || szTmp.equals("") ) {  return null;  }
        return szTmp;
    }

    /**
      * xpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createLabelConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.weightx = 0.0 ;
        gbc.insets  = new Insets(10,10,0,10) ;
        return gbc;
    }

    /**
      * R|[lgpCAEg̍쐬
      *
      * @return GridBagConstraints
      */
    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0 ;
        gbc.insets    = new Insets(10,10,0,10) ;
        return gbc;
    }
}
