/*
 * @(#)GenerateCSV.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Generator CSVt@C̏o
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/01/23
 */

package jp.co.nri.rid.generator;

import java.io.*;
import java.util.*;
import java.text.*;
import javax.swing.JTable;

import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.util.ZFileFilter;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZReverseEnumeration;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

/**
 * Rid CSVt@Co
 */
public class GenerateCSV2 extends GenerateParser {

    protected FileOutputStream    outFileStream = null;
    protected OutputStreamWriter  outWriter = null;

    /**
     * ftHgRXgN^
     */
    public GenerateCSV2() {}

    /**
     * CSV̐
     @ @param  JTable      table           o̓e[u
     * @param  String      out_file        o̓t@C
     * @return boolean
     */
    public boolean generateCSV(JTable table, String out_file) throws Exception {

        boolean ret = false;

        // FILE OPEN
        outFileStream = new FileOutputStream(out_file);
        outWriter = new OutputStreamWriter(outFileStream);
            
        // WRITE CSV
        writeTableHedder(table);
        writeTableData(table);

        // FILE CLOSE
        outWriter.close();

        return true;
    }

    /**
     * wb_[J}`ŏo
     * @param  RTable    table        e[u
     * @return void
     */
    private void writeTableHedder(JTable table) throws Exception {

        String  buff = "";
        for (int i = 0; i < table.getColumnCount(); i++) {
            String columnName = table.getColumnName(i);
            if (columnName == null) columnName = "";
            if (columnName.indexOf(",") >= 0) columnName = "\"" + columnName + "\"";
            if (i == 0) buff = buff + columnName;
            else        buff = buff + "," + columnName;
        }
        buff = buff + "\n";

        //o̓t@Cɏo
        outWriter.write(buff, 0, buff.length());
   }

    /**
     * e[uJ}`ŏo
     * @param  RTable    table        e[u
     * @return void
     */
    private void writeTableData(JTable table) throws Exception {

        String  buff = "";
        for (int i = 0; i < table.getRowCount(); i++) {
            for ( int j = 0; j < table.getColumnCount(); j++) {
                String dataName = ((String)table.getValueAt(i, j));

                if (dataName == null)          dataName = "";
                if (dataName.indexOf("\"") >= 0) dataName = charChange(dataName);
                if (dataName.indexOf(",") >= 0 || dataName.indexOf("\"") >= 0) dataName = "\"" + dataName + "\"";
                if (j == 0) buff = buff + dataName;
                else        buff = buff + "," + dataName;
            }
            buff = buff + "\n";
        }
        //o̓t@Cɏo
        outWriter.write(buff, 0, buff.length());
    }

    /**
     * _uR[eBVΉ
     */
    private String charChange(String name) {
        if (name == null) return "";
        String buf = "";
        StringBuffer sb = new StringBuffer(name);
        for (int i=0; i < sb.length(); i++) {
            char c = sb.charAt(i);
            if ('"' == c) buf = buf + "\"";
            buf = buf + c;
        }
        return buf;
    }

}
