/*
 * @(#)GenerateSiteMap.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Generator TCg}bv
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/02/19
 */
package jp.co.nri.rid.generator;

import java.io.*;
import java.util.*;

import org.w3c.dom.*;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;

import jp.co.nri.Ridual;
import jp.co.nri.rid.mapper.*;
import jp.co.nri.rid.error.*;
import jp.co.nri.rid.snapshot.*;

/**
 * Rid TCg}bv
 */
public class GenerateSiteMap extends GenerateParser {

    /** ev[gfBNg  **/
    protected String pr_templateDir;
    /** o̓fBNg **/
    protected String pr_outDir;
    /** htmlfBNg  **/
    protected String pr_htmlDir;
    /** Cfg  **/
    protected String pr_tab = "  ";
    /** URL **/
    protected String pr_url;


/**
  * ftHgRXgN^
  */
    public GenerateSiteMap() {
        pr_url = "";                          // URL
        pr_templateDir  = "";                 // ev[gfBNg
        pr_outDir       = "";                 // o̓fBNg
        pr_htmlDir      = "";                 // htmlfBNg
    }


/**
  * TCg}bv
  *
  * @param  Document    doc             hLg
  * @param  String      project_dir     vWFNgfBNg
  * @param  String      header_file     wb_t@C
  * @param  String      footer_file     tb^[t@C
  */
    public boolean generate(Document doc, String project_dir, String header_file,  String footer_file) throws Exception {

        boolean ret = false;

        //fBNg̎擾
        getDir(project_dir);

        //document̉
        ProjectInfo  project_info = new ProjectInfo();
        project_info = documentParser(doc, "", "");

        //TCg}bv̐
        ret = generateSiteMap(project_info, header_file, footer_file);

        return true;
    }


/**
  * URL̎擾
  *
  * @return String      TOP@URL
  */
    public String getUrl() throws Exception {
        return pr_url;
    }


/**
  * URL̐ݒ
  *
  * @param  String      url             TOP URL
  * @return void
  */
    private void setUrl(String url) throws Exception {
        pr_url = url;
    }


/**
  * fBNg̎擾
  *
  * @param  String      project_dir   vWFNgfBNg
  */
    private void getDir(String project_dir) throws Exception {

        ZResource res = ZApp.getTheApp().getResource();
        String template_dir = res.getString("rid.template.dir");        // ev[gfBNg
//        String html_dir     = res.getString("rid.html.dir");            // htmlfBNg

        pr_templateDir = project_dir + File.separator + template_dir;   // ev[gfBNg
//        pr_htmlDir     = project_dir + File.separator + html_dir;       // htmlfBNg
        pr_htmlDir     = Ridual.getHtmlDir();       // htmlfBNg
    }


/**
  * TCg}bv̐
  *
  * @param  ProjectInfo project_info    vWFNg
  * @param  String      header          wb_̃t@C
  * @param  String      footer          tb_̃t@C
  * @return void
  */
    private boolean generateSiteMap(ProjectInfo project_info, String header, String footer) throws Exception {

        boolean ret = false;
        xcopy xc = new xcopy();
        RidMessage ridMsg = new RidMessage();

        //@_sitemap.htmlL
        String template = pr_templateDir + File.separator + puTemplSitemap;
        if ( !xc.fileExists(template) ){
            throw new RidException(ridMsg.Error("E4001", template));
        }

        // o̓t@C
        String out = pr_htmlDir + File.separator + puOutSitemap;

        // ZONEXg̍쐬
        ZoneInfo zone_info = project_info.zone;
        String zoneList = "<ul>\n" + sitemapZoneMap(zone_info) + "</ul> \n";

        // TCg}bv̍쐬
        String siteMap = sitemapZoneInfo(zone_info, 0);

        // wb_t@CǍ
        String headerString = filname2String(pr_templateDir + File.separator + header);

        // tb^t@CǍ
        String footerString = filname2String(pr_templateDir + File.separator + footer);

        //f[^̐
        Document temp_data = sitemapData(zoneList, siteMap, headerString, footerString);

        // SiteMap̐
        Mapper mapper = new Mapper();
        ret = mapper.Type2(template, temp_data, out);
        if (!ret) {
            throw new RidException(ridMsg.Error("E4002", mapper.getErrorString()));
        }

        // Urlݒ
        setUrl(replaceWebFileSeparator(out));
        
        return ret;
    }

/**
  * ZoneXg쐬
  *
  * @param  ZoneInfo    zone            ZONE
  * @return String      ZoneXg̕
  */
    private String sitemapZoneMap(ZoneInfo zone) throws Exception {

        String zoneMap = "";
        zoneMap = "<li><a href=\"#" + zone.file + "\">" + zone.title + "(" + zone.name + ")</a>\n\r";
        //Zone
        for ( int n = 0; n < zone.zone_lst.size(); n++ ) {
            ZoneInfo zone_info = (ZoneInfo)zone.zone_lst.elementAt(n);
            zoneMap = zoneMap + sitemapZoneMap(zone_info);
        }
        return zoneMap;
    }


/**
  * TCg}bv̍쐬
  *
  * @param  ZoneInfo    zone            ZONE
  * @param  int         itag            ^O
  *
  * ZONE̒PʂŌJԂ
  *
  *   <ul> ZONE^Cg(ZONE)
  *     <li><a href="Page1"> PAGE1^Cg(Page1)
  *     <li><a href="Page2"> PAGE2^Cg(Page2)
  *     .....
  *   </ul>
  *
  *
  * @return String      TCg}bv̕
  */
    private String sitemapZoneInfo(ZoneInfo zone, int itag) throws Exception {

        String siteMap = "\n";

        siteMap = "<a name=\"#" + zone.file + "\"></a>\n" +  tagString(itag) + "<ul> " + zone.title + "(" + zone.name + ")\n\r";

        //Page
        for ( int i = 0; i < zone.page_lst.size(); i++ ) {
            PageInfo page_info = (PageInfo)zone.page_lst.elementAt(i);
            siteMap = siteMap + sitemapPageInfo(page_info, itag);
        }

        //Zone
        for ( int n = 0; n < zone.zone_lst.size(); n++ ) {
            ZoneInfo zone_info = (ZoneInfo)zone.zone_lst.elementAt(n);
            siteMap = siteMap + sitemapZoneInfo(zone_info, itag + 1);
        }

        siteMap = siteMap + tagString(itag) + "</ul>\n";

        return siteMap;
    }


/**
  * y[W̏쐬
  *
  * @param  PageInfo    page_info       PAGE
  * @param  int         itag            ^O
  *
  * ̕
  *     <li><a href="Page1"> PAGE1^Cg(Page1)
  *
  * @return String      y[W̕
  */
    private String sitemapPageInfo(PageInfo page_info, int itag) throws Exception {

        String name  = page_info.name;
        String file  = page_info.file;
        String title = page_info.title;

        return (tagString(itag + 1) + "<li><a href=\"" + file + "\">" + title + " (" + name + ")</a>\n\r");
    }

/**
  * ^Ő󔒕쐬
  *
  * @param  int         itag            ^O
  * @return String      󔒕
  */
    private String tagString(int itag) throws Exception {

        String tagString = "";

        for ( int i = 0; i < itag; i++ ) {
            tagString = tagString + pr_tab;
        }
        return tagString;
    }

/**
  * TCg}bṽf[^
  *
  * @param  String      page_name       y[W̖O
  * @return Document    y[W̃hg
  */
    private Document sitemapData(String zonemap, String sitemap, String header, String footer) throws Exception {

        XmlUtil xu = new XmlUtil();
        Document doc = new org.apache.xerces.dom.DocumentImpl();
        Element topElem = doc.createElement(puRootTag);
        doc.appendChild(topElem);
        xu.createOrSetTextValue(topElem, "zonemap", zonemap);
        xu.createOrSetTextValue(topElem, "sitemap", sitemap);
        xu.createOrSetTextValue(topElem, "header", header);
        xu.createOrSetTextValue(topElem, "footer", footer);
        return doc;

    }


/**
  * w肳ꂽt@C̓eString^ɕϊ
  *
  * @param  String      file_name       t@C
  * @return String      t@C̓e
  */
    private String filname2String(String file_name)  throws Exception  {

        boolean ret = false;
        String fileString = "";
        xcopy xc = new xcopy();
        RidMessage ridMsg = new RidMessage();

        //t@C̑݊mF
        ret = xc.fileExists(file_name);
        if (ret) {
            char str[]=new char[256];
            FileInputStream inFileStream = new FileInputStream(file_name);
            InputStreamReader InData=new InputStreamReader(inFileStream);
            while ((InData.read(str, 0, 1)) != -1) {
              fileString = fileString + str[0];
            }
            InData.close();
        } else {
             ZDebug.trace(ridMsg.Warning("W4002",file_name));
        }
        return fileString;
   }

}
