/*
 * @(#)RHTMLGenerator.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Generator
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.generator;

import java.util.*;
import java.io.File;
import java.text.*;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;

import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.snapshot.xcopy;


/**
  * Rid 
  */
public class RHTMLGenerator extends GenerateParser {

    /** [generate.page]vpeB  **/
    final static public String GENERATE_PAGE            = "generate.page";
    /** [generate.product]vpeB  **/
//    final static public String GENERATE_PRODUCT         = "generate.product";
    /** [generate.present]vpeB  **/
//    final static public String GENERATE_PRESENT         = "generate.present";
    /** [generate.sitemap]vpeB  **/
    final static public String GENERATE_SITEMAP         = "generate.sitemap";
    /** [generate.browser]vpeB  **/
    final static public String GENERATE_BROWSER         = "generate.browser";
    /** [generate.browser.exec]vpeB  **/
//    final static public String GENERATE_BROWSER_EXE     = "generate.browser.exec";
    /** [generate.browser_command]vpeB  **/
    final static public String GENERATE_BROWSER_COMMAND = "generate.browser_command";

    /** [generate.browser]vpeB̒l w[Product]    **/
//    final static public String BROWSER_PRODUCT = "Product";
    /** [generate.browser]vpeB̒l ŋ[Present]        **/
//    final static public String BROWSER_PRESENT = "Present";
    /** [generate.browser]vpeB̒l TCg}bv[Sitemap]  **/
//    final static public String BROWSER_SITEMAP = "Sitemap";

/**
  * ftHgRXgN^
  */
    public RHTMLGenerator() {}

/**
  * w^ŋ^TCg}bv iCj
  * @param  doc         hLg
  * @param  szPjDir     vWFNgfBNg
  * @return boolean     trueij/ falseisj
  */
    public boolean generate(DocDocument doc,String szPjDir) throws Exception {

        boolean ret = true;

        // \[X
        ZResource res = ZApp.getTheApp().getResource();

        //y[W iTrue:/false:Ȃj
        boolean page = res.getBoolean(GENERATE_PAGE);
        if (page)  ret = generatePageFrame(doc, szPjDir);

        //w iTrue:/false:Ȃj
/*
        boolean product = res.getBoolean(GENERATE_PRODUCT);
        if (product)  ret = generateProductFrame(doc, szPjDir);
*/

        //ŋ iTrue:/false:Ȃj
/*
        boolean present = res.getBoolean(GENERATE_PRESENT);
        if (present)  ret =generatePresentFrame(doc, szPjDir);
*/
		
        // TCg}bviTrue:/false:Ȃj
        boolean sitemap = res.getBoolean(GENERATE_SITEMAP);
        if (sitemap)  ret &= generateSiteMap(doc, szPjDir);
		
		if(ret) browserExec(szPjDir+File.separator+res.getString("rid.admin.dir")+File.separator+"index.html");
		
        return ret;
    }


/**
  * y[W
  * @param  doc         hLg
  * @param  szPjDir     vWFNgfBNg
  * @return boolean     trueij/ falseisj
  */
    public boolean generatePageFrame(DocDocument doc,String szPjDir) throws Exception {

        boolean ret = false;

        ZDebug.trace(" >> Page start... ");

        // Page
        GeneratePage page = new GeneratePage();
        ret = page.generate(doc, szPjDir);
        ZDebug.trace(" >> Page end... \"" + ret + "\"");
        return ret;
  }


/**
  * w
  * @param  doc         hLg
  * @param  szPjDir     vWFNgfBNg
  * @return boolean     trueij/ falseisj
  */
/*
    public boolean generateProductFrame(DocDocument doc,String szPjDir) throws Exception {

        boolean ret = false;

        ZDebug.trace(" >> Product start... ");

        // w
        GenerateProduct product = new GenerateProduct();
        ret = product.generate(doc, szPjDir);
        if (ret) {
            ret = browserExec(BROWSER_PRODUCT, product.getUrl());
        }

        ZDebug.trace(" >> Product end... \"" + ret + "\"");
        return ret;
  }
*/


/**
  * ŋ
  * @param  doc         hLg
  * @param  szPjDir     vWFNgfBNg
  * @return boolean     trueij/ falseisj
  */
/*
    public boolean generatePresentFrame(DocDocument doc,String szPjDir) throws Exception {

        boolean ret = false;

        ZDebug.trace(" >> Present start... ");

        // ŋ
        GeneratePresent present = new GeneratePresent();
        ret =  present.generate(doc, szPjDir);
        if (ret) {
            ret = browserExec(BROWSER_PRESENT, present.getUrl());
        }

        ZDebug.trace(" >> Present end... \"" + ret + "\"");
        return ret;
    }
*/
	

/**
  * SiteMap
  * @param  doc         hLg
  * @param  szPjDir     vWFNgfBNg
  * @return boolean     trueij/ falseisj
  */
    public boolean generateSiteMap(DocDocument doc,String szPjDir) throws Exception {

        boolean ret = false;

        ZDebug.trace(" >> SiteMap start... ");

        // ł́Aev[gfBNg̊et@CƂ
        String szHeader = "_header.html"; // wb_
        String szFooter = "_footer.html"; // tb^[

        // TCg}bv
        GenerateSiteMap siteMap = new GenerateSiteMap();
        ret =  siteMap.generate(doc, szPjDir, szHeader, szFooter);
//		if (ret) {
//            ret = browserExec(BROWSER_SITEMAP,siteMap.getUrl());
//		}
        ZDebug.trace(" >> SiteMap end... \"" + ret + "\"");

        return ret;

  }


/**
  * uEŰN
  * @param  gType       w/ŋ/sitemap
  * @param  url         URL
  * @return boolean     trueij/ falseisj
  */
  public boolean browserExec(String url) throws Exception{

      boolean ret = true;

      // \[X
      ZResource res = ZApp.getTheApp().getResource();

      // uEU\̗L true:N/false:NȂ
      boolean browser = res.getBoolean(GENERATE_BROWSER);

      if (browser) {
          // uEU\s Product:w/Present:ŋ/Sitemap:TCg}bv
//          String browser_exec = res.getString(GENERATE_BROWSER_EXE);
//          if (browser_exec.compareTo(gType) == 0) {
              // uEŨR}h
              String browser_command = res.getString(GENERATE_BROWSER_COMMAND);
              //Null̏ꍇ͏Ȃ
              if (!isNullString(browser_command)) {
                  // ݃`FbN
				if(!new File(browser_command).exists()){
					ZDebug.trace(new RidMessage().Warning("W4005",browser_command));
					return false;
				}
				
				File fl = new File(url);
				if(!fl.exists()){
					ZDebug.trace(new RidMessage().Warning("W4006",browser_command));
					return false;
				}
				Runtime.getRuntime().exec(browser_command + " " + fl.toURL());
/*
                  xcopy xc = new xcopy();
                  if (xc.fileExists(browser_command) && xc.fileExists(url) ) {
                  //if (xc.fileExists(url) ) {
                      // w肳ꂽuEUHTMLt@C\
                      Runtime.getRuntime().exec(browser_command + " file://" + url);
                  } else {
                      // uEU܂HTMLt@C݂Ȃꍇ
                      RidMessage ridMsg = new RidMessage();
                      if ( !xc.fileExists(browser_command) )
                          ZDebug.trace(ridMsg.Warning("W4005",browser_command));
                      if ( !xc.fileExists(url) )
                          ZDebug.trace(ridMsg.Warning("W4006",browser_command));
                      ret = false;
                  }
*/
              }
//          }
      }
      return ret;
  }

/**
  * ݂̎
  *
  * @return String (yyyy/MM/dd (EE) HH:mm:ss.SSS zz)
  */
    public String getDateString() throws Exception {
        Date date = new Date();
        DateFormat df = new SimpleDateFormat("yyyy/MM/dd (EE) HH:mm:ss.SSS zz");
        return df.format(date);
    }

}
