/*
 * @(#)RidGobManager.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-3 : Ridp GobANZXNX
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/10/23
 */

package jp.co.nri.rid.gob;

import java.util.Enumeration;

import jp.co.iti.fagot.geom.ZPoint;

import jp.co.iti.fagot.gob.IGobContainer;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.rid.doc.RidElement;
import jp.co.nri.rid.doc.RidElementZone;

/**
 * GobANZX
 */
public class RidGobManager {

	//## ][ ######################################################
	/**
	 * w肳ꂽWɑ݂ZoneGg擾
	 * @param panelId plʎq
	 * @param pt      W
//	 * @param element ړΏ
	 */
	static public GElement findParentZoneGob( String szPanelId, ZPoint pt/*,RidElement element*/ ) {

	Enumeration elm = GobManager.r_elements(szPanelId,GobManager.ALL);
	while ( elm.hasMoreElements() ) {
		// `悳ĂGob̈eƂȂ邩mF
		GElement paGob = (GElement)elm.nextElement();

		// mFΏۂZoneUnit
		IGobContainer container = paGob.getContainer();
		if ( container instanceof RidElementZone ) {

			// mFΏۂړW܂ł
			if ( paGob.getTransformedBounds().contains(pt) ) {

				RidElementZone paZone = (RidElementZone)container;
//				ZDebug.trace("paZone:"+paZone.getAttribute("File"));

				// mFΏۂAJgGgA܂́AJgGg̎qł
				// ړΏۂelementƓ悤ɈړĂ̂ŁAe][̑ΏۂƂȂ
				boolean isCurrent = false;
				Enumeration elmCur = GobManager.getCurrent(szPanelId).elements();
				while ( elmCur.hasMoreElements() ) {
					GElement curGob = (GElement)elmCur.nextElement();
					// mFΏۂJgH
					if ( curGob == paGob ) {
						isCurrent = true;
						break;
					}

					// mFΏۂJg̎qH
					IGobContainer curContainer = curGob.getContainer();
					if ( curContainer instanceof RidElementZone ) {
						RidElementZone curZone = (RidElementZone)curContainer;
						String curFile = curZone.getAttribute("File");
						// curFile.length()>0 FVK쐬łȂ
						// startsWith         FJg̎qłȂ
						if ( curFile.length()>0 && paZone.getAttribute("File").startsWith(curFile) ) {
							isCurrent = true;
							break;
//						} else {
//							ZDebug.trace("curZone not find:"+curZone.getAttribute("File"));
						}
					}
				}
				if ( !isCurrent ) {
					return paGob;
				}
			}
		}
	}
	return null;
	}

	//## Agr[g################################################
}
