/**
 * @(#)RIgnoreFiles.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : rid.ignore.prefix킷NX
 * @author  Intelligent Technology Inc.
 * @version 1.00 2001/10/01-2001/12/28
 * @see 
 */
package jp.co.nri.rid.importer;

// JAVA
import	java.util.*;

// W3C DOM

import	jp.co.nri.Rid;
import	jp.co.iti.fagot.doc.DocManager;

/* RID */
import	jp.co.nri.rid.error.*;
import	jp.co.nri.rid.analyzer.*;

/* ITI */
import	jp.co.iti.fagot.ZApp;
import	jp.co.iti.fagot.util.*;

/**
 * rid.ignore.prefixNX
 */
public class RIgnoreFiles{
//public class RIgnoreFiles implements iExceptionCode{
	private static final String KEY_IGNORE_PREFIX	= "rid.ignore.prefix";
	/**
	 * rid.ignore.prefixɊY邩肷B
	 * @param	name	t@C/fBNg
	 * @return	true	rid.ignore.prefixŎw肳ꂽL[[hŎn܂
	 * 			false	rid.ignore.prefixŎw肳ꂽL[[hŎn܂Ȃ
	 * @since	1.00
	 */
//	public static boolean ignorename(String name) throws RidException{
	public static boolean ignorename(String name){
		String lowername;
		try{ lowername = name.toLowerCase(); }
		catch(NullPointerException e){ return true; }
		
		StringTokenizer prefix;
		try{
			prefix = new StringTokenizer(ZApp.getTheApp().getResource().getString(KEY_IGNORE_PREFIX) ," ");
		}catch(NullPointerException e){
			return false;
//			throw new RidException(new RidMessage().Error(ERR_NotFoundResourceKey,KEY_IGNORE_PREFIX));
		}
		
		while(prefix.hasMoreTokens()){
			if(lowername.startsWith(prefix.nextToken().toLowerCase()))	return true;
		}
		return false;
	}
	
	/**
	 * rid.ignore.prefixɊY邩肷BpXɊ܂܂邷ׂẴt@C/fBNg`FbNB
	 * @param	name	t@CpX
	 * @return	true	rid.ignore.prefixŎw肳ꂽL[[hŎn܂
	 * 			false	rid.ignore.prefixŎw肳ꂽL[[hŎn܂Ȃ
	 * @since	1.00
	 */
//	public static boolean ignorefile(String file) throws RidException{
	public static boolean ignorefile(String file){
		StringTokenizer names;
		try{ names = new StringTokenizer(file ,"/"); }
		catch(NullPointerException e){ return true; }
		
		while(names.hasMoreTokens()){
			if(ignorename(names.nextToken()))	return true;
		}
		return false;
	}
}
