/*
 * @(#)HtmlMapper.java
 *
 * RID-X : Mapper
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/02/15
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */

package jp.co.nri.rid.mapper;

import java.io.*;
import java.util.*;
import java.net.URL;
import org.w3c.dom.*;
import jp.co.nri.rid.error.*;
import jp.co.nri.rid.snapshot.*;

/**
 * Mapper HTMLp
 */
public class HtmlMapper extends MapperBase {


/**
  * RXgN^
  *
  */
    public HtmlMapper() {}

/**
  * HTMLt@Cw^ȎluAo͂
  *
  * @param  String      in_file         ̓t@C
  * @param  String      out_file        o̓t@C
  * @param  String      tagName         ^O
  * @param  String      attrName        
  * @param  String      value           l
  * @return void
  */
    public boolean replaceHtmlTagAttribute(String in_file, String out_file, String tagName, String attrName, String value)  throws RidException, Exception {

        boolean ret = false;
        Vector tagName_lst = new Vector();

        // INFILEHTML^Oo
        Vector tag_lst = new Vector();
        htmlParser(in_file, tag_lst);

        // ^Ow肳ꂽ tagNamê݂ɂ
        for (int n = 0; n < tag_lst.size(); n ++ ) {
            // HTML^O̎擾
            TagItem htmlTag = (TagItem)tag_lst.elementAt(n);
            String compare = htmlTag.tagString.substring(1, Math.min(tagName.length()+1, htmlTag.tagString.length()) );
            
            if ( compare.equalsIgnoreCase(tagName) ) {
                htmlTag.keyName = getAttrValue(htmlTag.tagString, attrName);
                tagName_lst.add(htmlTag);
            }
        }

        if (tagName_lst.size() == 0) {
            // w肳ꂽtagNameȂꍇ͒ʏ̃Rs[
            xcopy xc = new xcopy();
            ret = xc.file(in_file, out_file);
        } else {
            // 
            ret = replaceGenerate(in_file, out_file, tagName_lst, attrName, value);
        }
        return true;
    }




/**
  * HTMLt@Cw^ȎluAo͂
  *
  * @param  String      in_file         ̓t@C
  * @param  String      out_file        o̓t@C
  * @param  Vector      replaceTag_lst  ^OXg
  * @param  String      attrName        
  * @param  String      value           l
  *
  * @return boolean     true() / false(s)
  */
    private boolean replaceGenerate(String in_file, String out_file, Vector replaceTag_lst,  String attrName, String value)  throws Exception{

        boolean ret = false;
        char str[]=new char[256];

        //t@C̃I[v
        InputStreamReader inData = new InputStreamReader(new FileInputStream(in_file));
        OutputStreamWriter outWriter = new OutputStreamWriter(new FileOutputStream(out_file));

        int pos = 0;
        for ( int n = 0; n < replaceTag_lst.size(); n ++ ) {

            TagItem replaceTag = (TagItem)replaceTag_lst.elementAt(n);

            // ^O̍ŏ̈ʒu܂ŏo͂
            while ((inData.read(str, 0, 1)) != -1) {
                if (pos < replaceTag.sPos) {
                    outWriter.write(str, 0, 1);
                } else {
                    pos++;
                    break;
                }
                pos++;
            }
            
            String replace = replaceString(replaceTag, attrName, value);
            outWriter.write(replace, 0, replace.length());

            // </MapRepeat>^O܂łǔ΂
            while ((inData.read(str, 0, 1)) != -1) {
                if (pos < replaceTag.ePos) {
                    //ǂݔ΂
                } else {
                    pos++;
                    break;
                }
                pos++;
            }
        }
        // Ō܂œǍ
        while ((inData.read(str, 0, 1)) != -1) {
          outWriter.write(str, 0, 1);
        }

        // t@CN[Y
        inData.close();
        outWriter.close();

        return true;
   }

/**
  * w^Ȏlu
  *
  * @param  TagItem     repeatTag       ^O
  * @param  String      attrName        
  * @param  String      value           l
  *
  * @return boolean     true() / false(s)
  */
    private String replaceString(TagItem repeatTag, String attrName, String value) throws Exception {

        String tagString = "";

        if (repeatTag.keyName != "") {
            String lowerTagString = repeatTag.tagString.toLowerCase();
            int pos  = lowerTagString.indexOf(attrName.toLowerCase());
            int sPos = repeatTag.tagString.indexOf(repeatTag.keyName, pos);
            int ePos = sPos + repeatTag.keyName.length();
            tagString = repeatTag.tagString.substring(0,sPos) + value + repeatTag.tagString.substring(ePos);
        } else {
            int end = repeatTag.tagString.length()-1;
            tagString = repeatTag.tagString.substring(0,end) + " " + attrName + "=\"" + value + "\">";
        }
        
        return tagString;
    }
}
