/*
 * @(#)MapperType1.java
 *
 * RID-X : Mapper
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/02/15
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */

package jp.co.nri.rid.mapper;


import java.util.*;
import java.text.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.w3c.dom.*;
import org.apache.xpath.XPathAPI;
import jp.co.iti.fagot.doc.DocManager;

import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.*;

import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;


/**
 * Mapper(Type1)
 */
public class MapperType1 extends MapperBase {

    /** G[bZ[W **/
    private static String pr_errorString;

    /*@ROOT@ELEMENT̒`FRID@*/
    /** RidProject̒` **/
    private static final String ROOT_ELEMENT  = "RidProject";
    /** MapAttr̒` **/
    private static final String MAP_ATTR      = "MapAttr";
    /** MapAttrData̒` **/
    private static final String MAP_ATTR_DATA = "MapAttrData";
    /** Rid_Tmp̒` **/
    private static final String RID_TMP       = "Rid_Tmp";
    /** MapData̒` **/
    private static final String MAPDATA       = "MapData";

    /*@̒`@*/
    /** srcTag̒` **/
    private static final String SRC_TAG       = "srcTag";
    /** srcKey̒` **/
    private static final String SRC_KEY       = "srcKey";
    /** dataTag̒` **/
    private static final String DATA_TAG      = "dataTag";
    /** dataKey̒` **/
    private static final String DATA_KEY      = "dataKey";
    /** inTag̒` **/
    private static final String IN_TAG        = "inTag";
    /** outAttr̒` **/
    private static final String OUT_ATTR      = "outAttr";
    /** name̒` **/
    private static final String NAME          = "name";


/**
  * RXgN^
  *
  */
    public MapperType1() {
        //NA
        pr_errorString = "";
    }

/**
  * (Mapper_Type1)
  *
  *   Mapt@CɋLqꂽeƂ
@*   Inputt@C̎w肳ꂽ^OɁAw肳ꂽƒlǉ
  *
  * @param  String      in_file         INPUTt@C   (HTML`)
  * @param  String      map_file        MAPt@C     (XML `)
  * @param  Document    data_doc        DATADocument  (XML `)
  * @param  String      out_file        OUTPUTt@C  (HTML`)
  *
  * @return boolean     true() / false (s)
@*--------------------------------------------------------------------------
  *
  *  #InputFile
  *   
  *   <a name="top"> gbvy[W </a>
  *
  *  #MapFile
  *
  *   <MapAttr srcTag="a" srcKey="name" dataTag="PageData" dataKey="name">
  *       <MapAttrData inTag="URL" outAttr="hrer"/>
  *   </MapAttr>
  *
  *   srcTag  : inputFilẽ^O
  *   srcKey  : inputFilȇL[
  *   dataTag : dataFilẽ^O
  *   dataKey : dataFilȇL[
  *   inTag   : dataFilẽf[^^O
  *   outAttr : inputFileɒǉ鑮
  *
  *       L[FsrcKey̒ldataKey̒l
  *
  *  #DataFile
  *
  *   <PageData name="top">
  *     <URL>../topFrame.html</URL>
  *   </PageData>
  *
  *  #OutputFile
  *   
  *   <a name="top" hrer="../topFrame.html"> gbvy[W </a>
  */
    public boolean Type1(String in_file, String map_file, Document data_doc, String out_file)  throws RidException {

        boolean ret = false;
        Vector  map_lst  = new Vector();
        Vector  data_lst = new Vector();
        RidMessage ridMsg = new RidMessage();

        try{
            //t@C̑݃`FbN
            if (checkFile(in_file) && checkFile(map_file)) {
                // MAPt@C͂
                ret = type1MapFileParser(map_file, map_lst);
                if (ret) {
                    // DatahLg͂
                    ret = type1DataDocParser(data_doc, map_lst, data_lst);
                    if (ret) {
                        //HTMLt@C̐
                        type1Generate(in_file, map_lst, data_lst, out_file);
                        ret = true;
                    }
                }
            }
            //C[Wt@CRs[
            if (ret){
              MapperResource  mr = new MapperResource();
              mr.imageFileCopy(in_file, out_file);
            }
        }
        catch(Exception e){
            String err_msg = ridMsg.Error("E4002"," (Mapper) " + e.getMessage());
            if (err_msg.indexOf("Filename too long") != -1) {
                err_msg =  ridMsg.Error("E4003"," (Mapper) " + e.getMessage());
            }
            throw new RidException(err_msg);
        }
        return ret;
    }

/**
  * (Mapper_Type1)
  *
  * }bvt@C
  *
  * @param  String      map_file        }bvt@C
  * @param  Vector      map_lst         MapItemNX̔z
  *
  * @return boolean     true() / false(s)
  */
    private boolean type1MapFileParser(String map_file, Vector map_lst) throws Exception {

        boolean ret = false;

        // }bvXMLt@C̃[gGg擾

        //Element root_elem = xmlFile2RootElement(map_file, ROOT_ELEMENT);
        Element root_elem = DocManager.createMapElement(map_file);

        if(root_elem != null) {
            // }bvXMLt@C̃}bv擾
            ret = getMapAttr(root_elem, map_lst);
        } else {
            String msg = "Root element name is different.";
            setErrorString(msg);
        }
        return ret;
    }


/**
  * (Mapper_Type1)
  *
  * }bvt@C̃}bv擾
  * }bv񂪂Ɍ肪ꍇ́Ãf[^̂ݖƂ
  *
  * @param  Element     root_elem       [gGg
  * @param  Vector      map_lst         MapItemNX̔z
  * @return boolean     true() / false(s)
  */
    private boolean getMapAttr(Element root_elem, Vector map_lst) throws Exception {

        boolean ret = false;

        // <MapAttr>^O̎擾
        NodeList map_elem_lst = XPathAPI.selectNodeList(root_elem, MAP_ATTR);
        for (int i =0; i < map_elem_lst.getLength(); i++) {

            Element attr_elem = (Element)map_elem_lst.item(i);

            // Attr̎擾
            String srcTag  = attr_elem.getAttribute(SRC_TAG);
            String srcKey  = attr_elem.getAttribute(SRC_KEY);
            String dataTag = attr_elem.getAttribute(DATA_TAG);
            String dataKey = attr_elem.getAttribute(DATA_KEY);

            // <MapAttrData>^O̎擾
            NodeList data_elem_lst = XPathAPI.selectNodeList(attr_elem, MAP_ATTR_DATA);
            for (int n =0; n < data_elem_lst.getLength(); n++) {
                Element data_elem = (Element)data_elem_lst.item(n);

                MapItem map = new MapItem();

                map.srcTag   = srcTag;
                map.srcKey   = srcKey;
                map.dataTag  = dataTag;
                map.dataKey  = dataKey;
                map.inTag    = data_elem.getAttribute(IN_TAG);
                map.outAttr  = data_elem.getAttribute(OUT_ATTR);

                // }bṽ`FbNiPłNULL̏ꍇ̓G[j
                if ( checkMapFile(map) ) {
                    if (-1 == map_lst.indexOf(map))   map_lst.add(map);
                }
            }
        }
        return true;
    }


/**
  * (Mapper_Type1)
  *
  * }bṽ`FbN
  * Pł("")̂̏ꍇ̓G[Ƃ
  *
  * @param  MapItem     map             MapItemNX
  * @return boolean     true() / false(s)
  */
    private boolean checkMapFile(MapItem map) {

        boolean ret = false;

        //SĂ̑ݒ肳Ă邩
        if (!(map.srcTag  == "" || map.srcKey == "" || map.dataTag == "" ||
              map.dataKey == "" || map.inTag  == "" || map.outAttr == "")) {
            ret = true;
        }

        return ret;
    }



/**
  * (Mapper_Type1)
  *
  *  f[^hLg̉
  *
  * @param  Document    data_doc        f[^t@C̃hg
  * @param  Vector      map_lst         MapItemNX̔z
  * @param  Vector      data_lst        DataItemNX̔z
  * @return boolean     true() / false(s)
  */
    private boolean type1DataDocParser(Document data_doc, Vector map_lst, Vector data_lst) throws Exception {

        boolean ret = false;

        // [gGg擾
        Element root_elem = root_elem = data_doc.getDocumentElement();
        if (!checkRootElement(root_elem, ROOT_ELEMENT)) {
            String msg = "Root element name is different.";
            setErrorString(msg);
            root_elem = null;
        }
        if(root_elem != null) {
            // f[^t@Cl擾
            ret = getDataTag(root_elem, map_lst, data_lst);
        }
        return ret;
    }


/**
  * (Mapper_Type1)
  *
  * f[^hLg}bvt@CɋLqĂ
@* f[^̎擾
  *
  * @param  Element     root_elem       [gGg
  * @param  MapItem     map_lst         MapItemNX̔z
  * @param  Vector      data_lst        DataItemNX̔z
  *
  * @return boolean     true() / false(s)
  */
    private boolean getDataTag(Element root_elem, Vector map_lst, Vector data_lst) throws Exception {

        XmlUtil xu = new XmlUtil();

        // }bv̌AJԂ
        for (int n = 0; n < map_lst.size(); n++) {

            // }bv̎擾
            MapItem map = (MapItem)map_lst.elementAt(n);

            // }bv[DataTag]̃m[hXg擾
            NodeList data_elem_lst = XPathAPI.selectNodeList(root_elem, map.dataTag);
            for (int i = 0; i < data_elem_lst.getLength(); i++) {
                //[DataTag]̃^ÕGg
                Element data_elem = (Element)data_elem_lst.item(i);

                // [DataTag]̃^O[dataKey]̎擾
                String key_name = data_elem.getAttribute(map.dataKey);

                // [InTag]̃m[h擾
                Element in_elem = (Element)XPathAPI.selectSingleNode(data_elem, map.inTag);
                if (in_elem != null) {

                    // [inTag]̒l擾
                    String in_data = xu.getTextValue(in_elem);

                    // f[^ǉ
                    DataItem data = new DataItem();
                    data.tagName  = map.srcTag;
                    data.keyName  = key_name;
                    data.inData   = in_data;
                    data.outAttr  = map.outAttr;
                    data_lst.add(data);
                }
            }
        }
        return true;
    }



/**
  * (Mapper_Type1)
@*
  * HTMLt@C̐
  *
  * @param  String      in_file         ̓t@C
  * @param  Vector      map_lst         }bviMapItem̔zj
  * @param  Vector      data_lst        f[^iDataItem̔zj
  * @param  String      out_file        o̓t@C
  * @return boolean     true() / false(s)
  */
    private boolean type1Generate(String in_file, Vector map_lst, Vector data_lst, String out_file) throws Exception {

        boolean ret = false;
        char str[]=new char[256];

        // ̓t@C}bṽ^O񂾂ʂ
        Vector inTag_lst = new Vector();
        inFileParser(in_file, map_lst, inTag_lst);

        // INPUTt@C̃I[v
        InputStreamReader InData=new InputStreamReader(new FileInputStream(in_file));

        // OUTOUTt@C̃I[v
        OutputStreamWriter outWriter = new OutputStreamWriter(new FileOutputStream(out_file));

        int pos = 0;
        for ( int n = 0; n < inTag_lst.size(); n ++ ) {
            TagItem inTag = (TagItem)inTag_lst.elementAt(n);

            //ϊ^O̍ŏ̈ʒu܂ŏo͂iMap̧قɂHTML^Ô݁j
            while ((InData.read(str, 0, 1)) != -1) {
                if (pos < inTag.sPos) {
                    outWriter.write(str, 0, 1);
                } else {
                    pos++;
                    break;
                }
                pos++;
            }

            // ϊ^OɈvf[^
            boolean  flag = false;
            for ( int m = 0; m < data_lst.size(); m ++ ) {
                DataItem data = (DataItem)data_lst.elementAt(m);

                if ( (data.tagName.compareToIgnoreCase(inTag.tagName) == 0) &&
                     (data.keyName.compareToIgnoreCase(inTag.keyName) == 0) ) {

                     String attr;
                     int end = inTag.tagString.length()-1;
                     attr = inTag.tagString.substring(0,end) + " " + data.outAttr + "=\"" + data.inData + "\">";
                     outWriter.write(attr, 0, attr.length());
                     flag = true;
                     break;
                }
            }
            if (!flag) {
                outWriter.write(inTag.tagString, 0, inTag.tagString.length());
            }

            // ϊ^ȌIʒu܂œǔ΂iINPUT FILE)
            while ((InData.read(str, 0, 1)) != -1) {
                if (pos < inTag.ePos) {
                    //ǂݔ΂
                } else {
                    pos++;
                    break;
                }
                pos++;
            }
        }

        // Ō܂œǍ(INPUT FILE)
        while ((InData.read(str, 0, 1)) != -1) {
            outWriter.write(str, 0, 1);
        }

        // t@CN[Y
        InData.close();
        outWriter.close();

        return true;
   }



/**
  * (Mapper_Type1)
  * HTMLt@C̃^O͂ĂAMapt@CɋLqĂ^Ô݂ɂ
  *
  * @param  String      in_file         ̓t@C
  * @param  Vector      map_lst         }bviMapItem̔zj
  * @param  Vector      data_lst        f[^iDataItem̔zj
  * @return void
  */
    private void inFileParser(String in_file, Vector map_lst, Vector inTag_lst) throws Exception {

        //in_file@Parser
        Vector tag_lst = new Vector();
        htmlParser(in_file, tag_lst);

        // HTML^O̔z񂩂AMapItemsrcTag^O𔲏o
        for (int n = 0; n < tag_lst.size(); n ++ ) {
            // HTML^O̎擾
            TagItem htmlTag = (TagItem)tag_lst.elementAt(n);

            // HTML^O̔z񂩂AMapItemsrcTag^O𔲏o
            for (int m = 0; m < map_lst.size(); m ++ ) {
                // HTML^O̎擾
                MapItem map = (MapItem)map_lst.elementAt(m);

                //啶ɕϊ
                String tagStringUp  = htmlTag.tagString.toUpperCase();
                String srcTagUp     = "<" + map.srcTag.toUpperCase();

                //srcTag^O̔f
                if (tagStringUp.indexOf(srcTagUp) != -1) {

                    //srcKey̎擾
                    String srcKey = getAttrValue(htmlTag.tagString, map.srcKey);

                    //
                    if (srcKey != ""){
                        TagItem srcTag = new TagItem();
                        srcTag.tagName     = map.srcTag;
                        srcTag.keyName     = srcKey;
                        srcTag.tagString   = htmlTag.tagString;
                        srcTag.sPos        = htmlTag.sPos;
                        srcTag.ePos        = htmlTag.ePos;
                        inTag_lst.add(srcTag);
                    }
                }
            }
        }
  }



/**
  * (Mapper_Type1@DOM)
@*
  *   Mapt@CɋLqꂽeƂ
@*   Input XMLɎw肳ꂽ^OɁAw肳ꂽƒlǉ
  *   InputXmlĈŁAVKXML𐶐Ȃ
  *
  * @param  Element     in_Element      INPUT XML̃[gGg
  * @param  String      map_file        MAPt@C     (XML `)
  * @param  Element     data_Element    DATA XML̃[gGg
  *
  * @return boolean     true() / false (s)
  *----------------------------------------------------------------------------
  *
  *  #InputFile
  *   
  *   <a name="top"> gbvy[W </a>
  *
  *  #MapFile
  *
  *   <MapAttr srcTag="a" srcKey="name" dataTag="PageData" dataKey="name">
  *       <MapAttrData inTag="URL" outAttr="hrer"/>
  *   </MapAttr>
  *
  *   srcTag  : inputFilẽ^O
  *   srcKey  : inputFilȇL[
  *   dataTag : dataFilẽ^O
  *   dataKey : dataFilȇL[
  *   inTag   : dataFilẽf[^^O
  *   outAttr : inputFileɒǉ鑮
  *
  *       L[FsrcKey̒ldataKey̒l
  *
  *  #DataFile
  *
  *   <PageData name="top">
  *     <URL>../topFrame.html</URL>
  *   </PageData>
  
  */
    public boolean Type1Xml(Element in_Element, String map_file, Element data_Element) throws RidException {

        boolean ret = false;
        Vector  map_lst  = new Vector();
        Vector  data_lst = new Vector();

        try{
            //t@C̑݃`FcN
            if (checkFile(map_file)) {

                // MAP XML Parser
                ret = type1MapFileParser(map_file, map_lst);
                if (ret) {
                    // DATA XML Parser
                    if(data_Element != null) {
                        ret = getDataTag(data_Element, map_lst, data_lst);
                        if (ret) {
                            //hLg̏C
                            ret = type1XmlGenerate(in_Element, map_lst, data_lst);
                        }
                    }
                }
            }
        }
        catch(Exception e){
            throw new RidException(e.getMessage());
        }

        return ret;
    }

/**
  * (Mapper_Type1@DOM)
  *
  * DOM̏u
  *
  * @param  Element     in_Element      INPUT XML̃[gGg
  * @param  Vector      map_lst         }bviMapItem̔zj
  * @param  Vector      data_lst        f[^iDataItem̔zj
  * @return void
  */
    private boolean type1XmlGenerate(Element in_Element, Vector map_lst, Vector data_lst) throws Exception {

        boolean ret = false;
        XmlUtil xu = new XmlUtil();
        String  xpath = "";

        // Map̌AJԂ
        for (int n = 0; n < map_lst.size(); n++ ) {
            MapItem map = (MapItem)map_lst.elementAt(n);

            // DatǎAJԂ
            for (int m = 0; m < data_lst.size(); m++ ) {
                DataItem data = (DataItem)data_lst.elementAt(m);

                // `Əo̓f[^vꍇ̂
                if (map.outAttr.compareTo(data.outAttr) == 0) {

                    //Element擾 w肳ꂽŒT
                    xpath = "//" + map.srcTag + "[@" + map.srcKey + " = '" + data.keyName + "']";
                    Element lelem = (Element)XPathAPI.selectSingleNode( in_Element, xpath );
                    if (lelem != null) {
						lelem.setAttribute(map.outAttr, data.inData);
//                        Attr attr = xu.createOrGetAttribute(lelem, map.outAttr);
//                        xu.createOrSetTextValue((Node)attr, data.inData);
                    }

                }
            }
            ret = true;
        }
        return ret;
   }

/**
  * ݂̎
  *
  * @return String (yyyy/MM/dd (EE) HH:mm:ss.SSS zz)
  */
    public String getDateString() throws Exception {
        Date date = new Date();
        DateFormat df = new SimpleDateFormat("yyyy/MM/dd (EE) HH:mm:ss.SSS zz");
        return df.format(date);
    }



/**
  * t@C݂邩ǂAǂݍ݉\ǂmF
  *
  * @param  String      in_file         Lt@C
  *
  * @return boolean     true(݂) / false (݂Ȃ)
  */
    public boolean checkFile(String in_file) {

        boolean ret = true;

        if (!isFile(in_file)) {
            String msg = "no such source file: \"" + in_file + "\"";
            setErrorString(msg);
            ret =  false;
        }
        return ret;
    }


/**
  * G[bZ[W̐ݒ
  *
  * @param  String      errorString     G[bZ[W
  * @return void
  */
    private void setErrorString(String errorString) {
        pr_errorString = errorString;
    }

/**
  * G[bZ[W̎擾
  *
  * @return String      G[bZ[W
  */
    public String getErrorString() {
        return pr_errorString;
    }

}