package jp.co.nri.rid.search;

import java.util.Hashtable;
import jp.co.nri.rid.xml.elementBooster;

/**
 * SPElementStatus $B%*%V%8%'%/%H$N%O%C%7%e%F!<%V%k$rJ];}$9$k%/%i%9(B<BR>
 * $B%-!<(B: element $B$N(B File $B%"%H%j%S%e!<%H(B
 * $BCM(B: SPElementStatus $B%*%V%8%'%/%H(B
 */
class SPElementStatusHash extends Hashtable {
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPElementStatusHash.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPElementStatusHash.java,v 1.2 2003-07-15 19:36:44+09 nsmr Exp $";

    /**
     * $B%3%s%9%H%i%/%?(B<BR>
     * elementBooster $B$NG[Ns$r<u$1$H$j!"$=$($>$l$NMWAG$r(B SPElementStatus
     * $B%*%V%8%'%/%H$K$7$F(B Hashtable $B$K3JG<$9$k(B
     * @param elements elementBooster $B$r3JG<$7$?G[Ns(B
     */
    SPElementStatusHash(elementBooster[] elements) {
        this(elements, false);
    } /* $B%3%s%9%H%i%/%?(B */


    /**
     * $B%3%s%9%H%i%/%?(B<BR>
     * elementBooster $B$NG[Ns$r<u$1$H$j!"$=$($>$l$NMWAG$r(B SPElementStatus
     * $B%*%V%8%'%/%H$K$7$F(B Hashtable $B$K3JG<$9$k(B
     * @param elements elementBooster $B$r3JG<$7$?G[Ns(B
     * @param toLower $B%O%C%7%e$N%-!<$KMxMQ$9$k%U%!%$%kL>$r!">.J8;z$KJQ49$7$?$b$N$K$9$k%U%i%0(B
     */
    SPElementStatusHash(elementBooster[] elements, boolean toLower) {
	super();

	if (elements == null) {
	    return;
	}
	if (elements.length == 0) {
	    return;
	}
	for (int i = 0; i < elements.length; i++) {
	    String attr;
	    attr = elements[i].attribute("Exist");

	    /* $BB8:_$9$k%(%l%a%s%H$N$_Cj=P$7!"B>$O<N$F$k(B */
	    if (attr == null) {
		continue;
	    }
	    if (!attr.equals("true")){
		continue;
	    } 
		
	    attr = elements[i].attribute("File");
	    if (attr == null) {
		continue;
	    }

	    SPElementStatus es = new SPElementStatus(elements[i]);
            if (toLower) {
                put(attr.toLowerCase(), es);
            } else {
                put(attr, es);
            }
	}
    } /* $B%3%s%9%H%i%/%?(B */


    /**
     * $B%O%C%7%e%F!<%V%k$K3JG<$5$l$F$$$k(B ElementStatus
     * $B%*%V%8%'%/%H$rJV$9!#(B
     * @param key element $B$N(B "File" $B%"%H%j%S%e!<%H(B
     * @return $B3:Ev$N%-!<$N(B ElementStatus
     */
    SPElementStatus get(String key){
        return get(key, false);
    }


    /**
     * $B%O%C%7%e%F!<%V%k$K3JG<$5$l$F$$$k(B ElementStatus
     * $B%*%V%8%'%/%H$rJV$9!#(B
     * @param key element $B$N(B "File" $B%"%H%j%S%e!<%H(B
     * @param toLower key $B$r>.J8;z$KJQ49$7$F(B Hash $B$rC5:w$9$k%U%i%0(B
     * @return $B3:Ev$N%-!<$N(B ElementStatus
     */
    SPElementStatus get(String key, boolean toLower){
	Object value;
        if (toLower) {
            value = super.get(key.toLowerCase());
        } else {
            value = super.get(key);
        }

	if (value == null) {
	    return null;
	}
	if (value instanceof SPElementStatus) {
	    return (SPElementStatus)value;
	}
	return null;
    }
} /* class SPElementStatusHash */
