package jp.co.nri.rid.search;

import java.util.Hashtable;
import jp.co.nri.rid.xml.elementBooster;


/**
 * $B%U%!%$%k%?%$%W$4$H$K=87W$7$?!"(B
 * SPCountAndSize $B%*%V%8%'%/%H$r3JG<$9$k%O%C%7%e%F!<%V%k(B
 */
class SPFileTypeHash extends Hashtable {
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPFileTypeHash.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPFileTypeHash.java,v 1.3 2003-06-17 16:36:54+09 nsmr Exp $";

    /**
     * $B%3%s%9%H%i%/%?(B
     * @param elements $B=87W$9$k%(%l%a%s%H$NG[Ns(B
     */
    SPFileTypeHash(elementBooster[] elements) {
	super();

	for (int i = 0; i < elements.length; i++) {
	    String fileType = elements[i].attribute("FileType");
	    if (fileType == null) {
		fileType = "unknown";
	    }

	    String exist = elements[i].attribute("Exist");
	    if (exist == null) {
		fileType = "not exist";
	    } else if (exist.equals("false")) {
		fileType = "not exist";
	    }

	    String size = elements[i].attribute("Size");
	    if (size == null) {
		size = "0";
	    } else if (fileType.equals("not exist")) {
		size = "0";
	    }

            int sizeInt;
            try {
                sizeInt = Integer.parseInt(size);
            } catch (NumberFormatException e) {
                sizeInt = 0;
            }

	    SPCountAndSize cs = get(fileType);
	    if (cs == null) {
		cs = new SPCountAndSize(1, sizeInt);
	    } else {
		cs.count++;
		cs.size += sizeInt;
	    }
	    put(fileType, cs);
	}
    } /* $B%3%s%9%H%i%/%?(B */


    /**
     * $B%O%C%7%e%F!<%V%k$K3JG<$5$l$F$$$k(B SPCountAndSize
     * $B%*%V%8%'%/%H$rJV$9!#(B
     * @param key $B%U%!%$%k%?%$%W(B
     * @return $B3:Ev$N%U%!%$%k%?%$%W$N(B SPCountAndSize $B%*%V%8%'%/%H(B
     */
    SPCountAndSize get(String key){
	Object value = super.get(key);
	if (value == null) {
	    return null;
	}
	if (value instanceof SPCountAndSize) {
	    return (SPCountAndSize)value;
	}
	return null;
    }


    int getCount(String key){
	Object value = super.get(key);
	if (value == null) {
	    return 0;
	}
	if (value instanceof SPCountAndSize) {
	    return ((SPCountAndSize)value).count;
	}
	return 0;
    }


    int getSize(String key){
	Object value = super.get(key);
	if (value == null) {
	    return 0;
	}
	if (value instanceof SPCountAndSize) {
	    return ((SPCountAndSize)value).size;
	}
	return 0;
    }
} /* class SPFileTypeHash */
