package jp.co.nri.rid.search;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.table.JTableHeader;

class SPHeaderListener implements MouseListener {
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPHeaderListener.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPHeaderListener.java,v 1.6 2003-06-26 16:09:39+09 nsmr Exp $";

    public void mouseEntered(MouseEvent e){
    }

    public void mouseExited(MouseEvent e){
    }

    public void mousePressed(MouseEvent e){
    }

    public void mouseReleased(MouseEvent e){
    }

    public void mouseClicked(MouseEvent e) {
        /* $B%$%Y%s%HH/@885$N%F!<%V%k%X%C%@$r<hF@(B
           $BH/@885$,(B JTableHeader $B0J30$N>l9g$O(B return */
        JTableHeader header = getTableHeader(e);
        if (header == null) {
            return;
        } 

        /* $B%$%Y%s%HH/@885$N%F!<%V%k%X%C%@$,(B SPTableModel $B$N%X%C%@$G$J$1$l$P(B
           return */
        Object o = header.getTable().getModel();
        if (!(o instanceof SPTableModel)) {
            return;
        }
        SPTableModel model = (SPTableModel)o;

        int columnIndex = getColumnIndex(e);
        if (columnIndex >= 0) {
            model.sort(columnIndex, true);
        }
    }

    /**
     * $B%$%Y%s%H$NH/@8$7$?%+%i%`$N!"%b%G%k>e$N(B index $B$rJV$9(B
     * @param e $B%^%&%9%$%Y%s%H(B
     * @return $B%X%C%@$N(B renderer
     */
    int getColumnIndex(MouseEvent e) {
        JTableHeader header = getTableHeader(e);
        if (header == null) {
            return -1;
        }

        /* $BI=<(>e$NNsHV9f$N<hF@(B */
        int columnPos = header.columnAtPoint(e.getPoint());

        if (columnPos < 0) {
            return -1;
        }

        /* $B%G!<%?%b%G%k>e$NNsHV9f$N<hF@(B */
        return header.getColumnModel().getColumn(columnPos).getModelIndex();
    } /* getColumnIndex */


    /**
     * $B%$%Y%s%H$NH/@8$7$?%X%C%@$rJV$9(B
     * @param e $B%^%&%9%$%Y%s%H(B
     * @return $B%F!<%V%k$N%X%C%@(B
     */
    JTableHeader getTableHeader(MouseEvent e) {
        JTableHeader header;

        Object o = e.getSource();
        if (!(o instanceof JTableHeader)) {
            return null;
        }
        return (JTableHeader)o;
    } /* getTableHeader */
} /* class SPHeaderListener */
