package jp.co.nri.rid.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class SPHeaderRenderer extends JButton implements TableCellRenderer {
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPHeaderRenderer.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPHeaderRenderer.java,v 1.5 2003-07-01 13:52:17+09 nsmr Exp $";

    private Color defaultBackground;


    /** RXgN^ */
    public SPHeaderRenderer(){
        defaultBackground = getBackground();
    }


    public Component getTableCellRendererComponent(JTable table, Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus, int row,
                                                   int column) {
        setBorder(null);
        // setMargin(new Insets(0, 0, 0, 0));
        setText(value.toString());

        /* Rendering 悤ƂĂJ̃f̃CfNX擾 */
        int modelIndex = table.convertColumnIndexToModel(column);

        /* łɃ\[gς݂̏ꍇAL[ƂȂĂJ擾 */
        if (!(table.getModel() instanceof SPTableModel)) {
            return this;
        }
        SPTableModel tableModel = (SPTableModel)table.getModel();
        int sortedModelIndex = tableModel.getModelIndexOfSortedColumn();
        if (sortedModelIndex == -1) {
            return this;
        }

        /* Rendering 悤ƂĂJA\[g̃L[ƂȂĂJ
         * Ȃ΁AwiFύX */
        if (sortedModelIndex == modelIndex) {
            setBackground(table.getSelectionBackground());
        } else {
            setBackground(defaultBackground);
        }

        return this;
    }
} /* class SPHeaderRenderer */
