/*
 * @(#)snapshot.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : XibvVbg
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/01/31
 */
package jp.co.nri.rid.snapshot;

import java.io.File;
import java.util.Date;
import java.lang.Math;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;

import jp.co.nri.rid.mapper.HtmlMapper;

/**
 * XibvVbg
 */
public class snapshot {

    /** rid.work.dirvpeB  **/
    final static public String RID_WORK_DIR     = "rid.work.dir";
    /** rid.admin.dirvpeB  **/
    final static public String RID_ADMIN_DIR    = "rid.admin.dir";
    /** rid.team.dirvpeB  **/
    final static public String RID_TEAM_DIR     = "rid.team.dir";
    /** rid.public.dirvpeB  **/
    final static public String RID_PUBLIC_DIR   = "rid.public.dir";
    /** rid.snapshot.dirvpeB  **/
    final static public String RID_SNAPSHOT_DIR = "rid.snapshot.dir";
    /** snapshot.bgcolorvpeB  **/
    final static public String SNAPSHOT_BGCOLOR = "snapshot.bgcolor";

    /** WorkfBNg                  **/
    protected String pr_workDir;
    /** AdminfBNg                 **/
    protected String pr_adminDir;
    /** wfBNg            **/
    protected String pr_teamDir;
    /** ŋfBNg                **/
    protected String pr_publicDir;
    /** XibvVbgfBNg      **/
    protected String pr_snapshotDir;
    /** XibvVbgwiF            **/
    protected String pr_bgColor;
    /** XibvVbgfBNg  **/
    protected String pr_snapshotDestDir;

    /** iro[gslkt@C(_navi.html)  **/
    static final String pr_naviHtml = "_navi.html";
    /** iro[gslkt@C(_navi.htm)   **/
    static final String pr_naviHtm  = "_navi.htm";
    /** ftHgobNOEh              **/
    static final String pr_gray     = "#808080";

  /**
   * ftHgRXgN^
   */
  public snapshot() {
      pr_adminDir = "";
      pr_teamDir = ""; 
      pr_publicDir = "";
      pr_snapshotDir = "";
      pr_bgColor = "";
      pr_snapshotDestDir = "";
  }

/**
  * XibvVbgs
  *
  * @param  String      szPjDir         vWFNgchq
  * @param  String      time_stamp      ^CX^viVK쐬fBNgj
  * @return boolean     true() / false (s)
  */
    public boolean exec(String szPjDir, String time_stamp) throws Exception {

        boolean ret = false;

        // \[XfBNgQ̎擾
        ZResource res  = ZApp.getTheApp().getResource();
        pr_workDir     = szPjDir + File.separator + res.getString(RID_WORK_DIR);
        pr_adminDir    = szPjDir + File.separator + res.getString(RID_ADMIN_DIR);
        pr_teamDir     = szPjDir + File.separator + res.getString(RID_TEAM_DIR); 
        pr_publicDir   = szPjDir + File.separator + res.getString(RID_PUBLIC_DIR);
        pr_snapshotDir = szPjDir + File.separator + res.getString(RID_SNAPSHOT_DIR); 
        pr_bgColor     = res.getString(SNAPSHOT_BGCOLOR); 
    
        // Rs[̃fBNgɃ^CX^ṽfBNg𐶐
        pr_snapshotDestDir = time_stamp;
        xcopy xc = new xcopy();
        xc.makeDir(pr_snapshotDir + File.separator + pr_snapshotDestDir);

        // WORKfBNgRs[
        String newWorkDir = pr_snapshotDir + File.separator + pr_snapshotDestDir + File.separator + res.getString(RID_WORK_DIR);
        ret = directory(pr_workDir, newWorkDir);

        return ret;
    }

/**
  * fBNg̃Rs[
  *
  * @param  String      source          ړfBNg
  * @param  String      destination     ړfBNg
  *
  * @return boolean     true() / false (s)
  */
    private boolean directory(String source, String destination) throws Exception {

        boolean ret = false;
        xcopy xc = new xcopy();
        File source_file = new File(source);
        File destination_file = new File(destination);

        // fBNg̗L
        ret = source_file.exists();
        if (ret){
            //fBNg̐^tύX
            ret = xc.makeDir(destination);
            if (ret) destination_file.setLastModified(source_file.lastModified());

            // t@CуfBNg̃Xg擾
            String[] source_lst =  source_file.list();

            //t@C܂̓TufBNg폜
            for (int n = 0; n < source_lst.length; n++) {
                ret = movement(source,  destination, source_lst[n]);
            }
        }
        return ret;
    }


/**
  * fBNg^t@Cŕ
  *
  * @param  String      source          ړfBNg
  * @param  String      destination     ړfBNg
  * @param  String      filename        t@C
  *
  * @return boolean     true() / false (s)
  */
    private boolean movement(String source, String destination, String filename) throws Exception {

        boolean ret = false;
        xcopy xc = new xcopy();

        String source_name      = source + File.separator + filename;
        String destination_name = destination + File.separator + filename;
        File source_file = new File(source_name);
        File destination_file = new File(destination_name);

        //݊mF
        ret = source_file.exists();
        if (ret) {

            // fBNg̏ꍇ
            if ( source_file.isDirectory() ) {
                // admin/team/publicfBNg̏ꍇ
                if ( source_name.equalsIgnoreCase(pr_adminDir) ) {
                    // AdminfBNg̈ړ
                    ret = admin_directory(source_name, destination_name);
                } else if ( source_name.equalsIgnoreCase(pr_teamDir) || source_name.equalsIgnoreCase(pr_publicDir) ) {
                    // Portal____fBNg̈ړ
                    ret = portal_directory(source_name, destination_name);
                } else {
                    // ȊÖړ
                    ret = xc.directory(source_name, destination_name);
                }

            } else if ( source_file.isFile() ) {
                // t@C̈ړ
                ret = xc.file(source_name, destination_name);
            }

        }
        return ret;
    }


/**
  * AdminfBNg̃Rs[
  *
  * AdminXXX_navi.html̂݁AwiFύXăRs[
  *
  * @param  String      source          ړfBNg
  * @param  String      destination     ړfBNg
  *
  * @return boolean     true() / false (s)
  */
    private boolean admin_directory(String source, String destination) throws Exception {

        boolean ret = false;
        xcopy xc = new xcopy();
        File source_file = new File(source);
        File destination_file = new File(destination);

        // fBNg̗L
        ret = source_file.exists();
        if (ret){

            //fBNg̐^tύX
            ret = xc.makeDir(destination);
            if (ret) destination_file.setLastModified(source_file.lastModified());

            // t@CуfBNg̃Xg擾
            String[] source_lst =  source_file.list();

            //t@C܂̓TufBNg폜
            for (int n = 0; n < source_lst.length; n++) {
                String lowerFile = source_lst[n].toLowerCase();

                if ( (lowerFile.lastIndexOf(pr_naviHtml) != -1) || 
                     (lowerFile.lastIndexOf(pr_naviHtm)  != -1) ) {
                    // _navi.html̏ꍇ
                    ret = navi_move(source + File.separator + source_lst[n], destination + File.separator + source_lst[n]); 
                } else {
                    // _navi.htmlłȂꍇ
                    ret = movement(source,  destination, source_lst[n]);
                }
            }
        }
        return ret;
    }




/**
  * portalfBNg̃Rs[
  *
  * portalXXX_navi.html̂݁AwiFύXăRs[
  * iTufBNg܂ށj
  *
  *
  * @param  String      source          ړfBNg
  * @param  String      destination     ړfBNg
  *
  * @return boolean     true() / false (s)
  */
    private boolean portal_directory(String source, String destination) throws Exception {

        boolean ret = false;
        xcopy xc = new xcopy();
        File source_file = new File(source);
        File destination_file = new File(destination);

        // fBNg̗L
        ret = source_file.exists();
        if (ret){

            //fBNg̐^tύX
            ret = xc.makeDir(destination);
            if (ret) destination_file.setLastModified(source_file.lastModified());

            // t@CуfBNg̃Xg擾
            String[] source_lst =  source_file.list();

            //t@C܂̓TufBNg폜
            for (int n = 0; n < source_lst.length; n++) {
                ret = portal_movement(source, destination, source_lst[n]);
            }
        }
        return ret;
    }



/**
  * portalfBNg̕
  *
  * @param  String      source          ړfBNg
  * @param  String      destination     ړfBNg
  * @param  String      filename        t@C
  *
  * @return boolean     true() / false (s)
  */
    private boolean portal_movement(String source, String destination, String filename) throws Exception {

        boolean ret = false;
        xcopy xc = new xcopy();
        String source_name      = source + File.separator + filename;
        String destination_name = destination + File.separator + filename;
        File source_file = new File(source_name);
        File destination_file = new File(destination_name);

        //݊mF
        ret = source_file.exists();
        if (ret) {
            if (source_file.isDirectory()) {
                //fBNg̏ꍇ
                ret = portal_directory(source_name, destination_name);
            } else if (source_file.isFile() ) {
                //t@C̏ꍇ
                String lowerFile = source_name.toLowerCase();
                if ( (lowerFile.lastIndexOf(pr_naviHtml) != -1) || 
                     (lowerFile.lastIndexOf(pr_naviHtm)  != -1) ) {
                    // _navi.html / _navi.htm ̏ꍇ
                    ret = navi_move(source_name, destination_name); 
                } else {
                    // t@C̈ړ
                    ret = xc.file(source_name, destination_name);
                }
            }
        }
        return ret;
    }


/**
  * iro[̂gslkt@Cړ
  *
  * @param  String      source          ړfBNg
  * @param  String      destination     ړfBNg
  *
  * @return boolean     true() / false (s)
  */
    private boolean navi_move(String source, String destination) throws Exception {
        
        if (pr_bgColor == "") pr_bgColor = pr_gray;
        HtmlMapper mapper = new HtmlMapper();
        mapper.replaceHtmlTagAttribute(source, destination, "body", "bgcolor", pr_bgColor);

        //t̕ύX
        File source_move = new File(source);
        File destination_move = new File(destination);
        destination_move.setLastModified(source_move.lastModified());

        return true;
    }


/**
  * ݂̎𕶎Ŏ擾(yyyyMdd_HHmmssSSS)
  *
  * @return String  (yyyyMdd_HHmmssSSS)
  */
    public String time_stamp() {

        String timestamp;
        Date date = new Date();
        DateFormat df = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
        timestamp = df.format(date);
        return timestamp;
    }

}
