/**
 * @(#)RClmDefs.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : RID Colum Defines
 * @author  Intelligent Technology Inc.
 * @version 1.00 2001/10/01-2002/01/08
 * @see ClmDefs
 */
package	jp.co.nri.rid.table;

import	java.util.*;
import	jp.co.iti.fagot.doc.DocManager;
import	jp.co.iti.fagot.*;
import	jp.co.iti.fagot.util.*;

/**
 * RTablep̃J
 */

public class RClmDefs extends ClmDefs{
	private	String			myTableName;
	public	KeyMap			keymap;
	public	AttributeMap	attributemap;
	
//--------[[ constructor ]]----------------------------------------------------
	/**
	 * @param	tablename	e[u("table.pages")
	 */
	public RClmDefs(String tablename){
		myTableName 	= new String(tablename);
		keymap 			= new KeyMap();
		attributemap	= new AttributeMap();
		
		// Table Columns
		ZResource	res			= ZApp.getTheApp().getResource();
		ZProperties	properties	= DocManager.loadProperty( DocManager.ELEMENT );
//		String[]	attributes	= ZString.tokenize(properties.getProperty(myTableName+".attributes"));
		String[]	attributes	= ZString.tokenize(properties.getProperty(myTableName+".colums.names"));
		
		// column data
		int mx = attributes.length;
		for(int i=0;i<mx;i++){
			String name	= attributes[i];
			String type	= properties.getProperty("attributes."+name+".type");
			int width	= res.getInt(myTableName+".columns."+name+".width" ,75);
			boolean editable = properties.getBoolean(myTableName+".colums.editable."+name ,true);
			ClmDef	clmdef	= new ClmDef(name ,type ,name ,editable ,width);
			clmdef.sorttype	= properties.getProperty("attributes."+name+".sorttype");
			add(clmdef);
			
		}
		
		// units
		String[] units = ZString.tokenize(properties.getProperty(myTableName+".units"));
		mx = units.length;
		for(int i=0;i<mx;i++){
			String		tagname		= units[i];
			String[]	names	= ZString.tokenize(properties.getProperty(myTableName+".units."+tagname+".attributes"));
			if(0>=names.length) names	= ZString.tokenize(properties.getProperty(tagname+".attributes"));
			add(tagname ,names);
			
			// QƃjbgQƃL[\
			String [] runits = ZString.tokenize(properties.getProperty(myTableName+".units."+tagname+".reference"));
			int mx2=runits.length;
			for(int j=0;j<mx2;j++){
				String unitname = properties.getProperty(myTableName+".units."+tagname+".reference."+runits[j]+".unit");
				String [] tokens = ZString.tokenize(properties.getProperty(myTableName+".units."+tagname+".reference."+runits[j]+".key") ,":");
				if(2 == tokens.length)	keymap.key(tagname ,runits[j] ,tokens[0] ,unitname ,tokens[1]);
			}
			
			// QƃjbgΉ\
			mx2=names.length;
			for(int j=0;j<mx2;j++){
				String [] tokens = ZString.tokenize(properties.getProperty(myTableName+".units."+tagname+"."+names[j]) ,".");
				if(2 == tokens.length)	attributemap.add(tagname ,names[j] ,tokens[0] ,tokens[1]);
				if(1 == tokens.length)	attributemap.add(tagname ,names[j] ,null ,tokens[0]);
			}
		}
		
	}
	
//--------[[ open method ]]----------------------------------------------------
	/**
	 * J*.propertiest@CɕۑB
	 * @since	1.00
	 */
	public void save(){
		ZResource	res	= ZApp.getTheApp().getResource();
		ClmDef[] clmdefs = ClmDefs();
		
		int mx = clmdefs.length;
		for(int i=0;i<mx;i++){
			ClmDef clmdef = clmdefs[i];
			res.putInt(myTableName+".columns."+clmdef.name+".width" ,clmdef.column.getWidth());
		}
	}
	
}
