/**
 * @(#)ChooseCEC.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : Choose Cell Editor Component
 * @author  Intelligent Technology Inc.
 * @version 1.00 2001/10/01-2002/03/26
 * @see iCellEditorComponent
 */
package	jp.co.nri.rid.table.editor;

import	java.awt.*;
import	java.awt.event.*;
import	javax.swing.*;

/**
 * lI邽߂̃ZGfB^/_R|[lg(R{{bNX)
 */

public class ChooseCEC extends JComboBox implements iCellEditorComponent{
	protected Color myFore;
	protected Color myBack;
	private CECAdapter myCECAdapter;
	
	protected ChooseCEC(){}
	
	/**
	 * @param	editable	ҏWہB
	 * @param	listener	ANVXi[B
	 * @since	1.00
	 */
	public ChooseCEC(boolean editable ,ActionListener listener){ init(editable ,listener); }
	
	/**
	 * @param	items		XgzB
	 * @param	editable	ҏWہB
	 * @param	listener	ANVXi[B
	 * @since	1.00
	 */
	public ChooseCEC(String[] items ,boolean editable ,ActionListener listener){
		super(items);
		insertItemAt("" ,0);
		init(editable ,listener);
	}
	
	/**
	 * ɃRXgN^ĂяoB
	 * @param	editable	ҏWہB
	 * @param	listener	ANVXi[B
	 * @since	1.00
	 */
	protected void init(boolean editable ,ActionListener listener){
		myFore = getForeground();
		myBack = getBackground();
		setBorder(null);
		editable(editable);
		addActionListener(listener);
		if(listener instanceof CECAdapter){
			myCECAdapter = (CECAdapter)listener;
			playCECAdapter();
		}
	}
	
	/**
	 * Zl(String)擾B
	 * @return	ZlB
	 * @since	1.00
	 */
	public String		text(){	return (String)getSelectedItem();	}
	
	/**
	 * Zlݒ肷B
	 * @param	text	ZlB
	 * @since	1.00
	 */
	public void			text(String text){
		pauseCECAdapter();
		/*** fuku *** 20020523 */
/*
		int nAt = 0;
		if ( text != null ) {
			nAt = index(text);
		}
		setSelectedIndex(nAt);
*/
		setSelectedIndex(index(text));
		playCECAdapter();
	}
	
	/**
	 * GfB^R|[lg擾B
	 * @return	GfB^R|[lgB
	 * @since	1.00
	 */
	public JComponent	component(){ return this; }
	
//	protected int index(String text){
	private int index(String text){
//		if(null==text)	return -1;
		if(null==text)	return 0;
		int mx = getItemCount();
		for(int i=0;i<mx;i++){
			if(getItemAt(i).toString().equals(text))	return i;
		}
		
//		return -1;
		return 0;
	}
	
	/**
	 * ̓spublicƂȂĂ邪AgpȂƁB
	 * @since	1.00
	 */
	public void	focus(boolean hasFocus ,JTable table){
		if(hasFocus){
			setForeground(table.getSelectionForeground());
			setBackground(table.getSelectionBackground());
		}
		else{
//			setForeground(table.getForeground());
//			setBackground(table.getBackground());
			setForeground(myFore);
			setBackground(myBack);
		}
	}
	
	/**
	 * ҏWۂݒ肷B
	 * @param	editable	true:ҏW false:ҏWsB
	 * @since	1.00
	 */
	public void editable(boolean editable){ setEnabled(editable); }
	
	/**
	 * ANVXi[ꎞ~B
	 * @since	1.00
	 */
	public void pauseCECAdapter(){
		try { myCECAdapter.editor(null); }
		catch(NullPointerException e){}
	}
	
	/**
	 * ANVXi[̈ꎞ~B
	 * @since	1.00
	 */
	public void playCECAdapter(){
		try { myCECAdapter.editor(this); }
		catch(NullPointerException e){}
	}
}
