/**
 * @(#)TextCEC.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : Boolean Cell Editor Component
 * @author  Intelligent Technology Inc.
 * @version 1.00 2001/10/01-2002/03/26
 * @see iCellEditorComponent
 */
package	jp.co.nri.rid.table.editor;

import java.awt.Component;
import java.awt.event.*;
import javax.swing.*;

/**
 * eLXg̓ZGfB^/_R|[lg(eLXgtB[h)
 */
public class TextCEC extends JTextField implements iCellEditorComponent{
	
	/**
	 * @param	editable	ҏWہB
	 * @param	listener	ANVXi[B
	 * @since	1.00
	 */
	public TextCEC(boolean editable ,ActionListener listener){
		setBorder(null);
		editable(editable);
		addActionListener(listener);
		if(listener instanceof CECAdapter)	((CECAdapter)listener).editor(this);
	}
	
	/**
	 * Zl(String)擾B
	 * @return	ZlB
	 * @since	1.00
	 */
	public String		text(){				return getText();	}
	
	/**
	 * Zlݒ肷B
	 * @param	text	ZlB
	 * @since	1.00
	 */
	public void			text(String text){	setText(text);		}
	
	/**
	 * GfB^R|[lg擾B
	 * @return	GfB^R|[lgB
	 * @since	1.00
	 */
	public JComponent	component(){		return this;		}
	
	/**
	 * ̓spublicƂȂĂ邪AgpȂƁB
	 * @since	1.00
	 */
	public void			focus(boolean hasFocus ,JTable table){
		if(hasFocus){
			setForeground(table.getSelectionForeground());
			setBackground(table.getSelectionBackground());
		}
		else{
			setForeground(table.getForeground());
			setBackground(table.getBackground());
		}
	}
	
	/**
	 * ҏWۂݒ肷B
	 * @param	editable	true:ҏW false:ҏWsB
	 * @since	1.00
	 */
	public void editable(boolean editable){ setEnabled(editable); }
}
