/**
 * @(#)HTMLEditorKitEx.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/09/02
 */
package	jp.co.nri.rid.web;

import	java.io.*;
import	javax.swing.text.*;
import	javax.swing.text.html.*;
import	javax.swing.text.html.parser.*;

/**
 * WebPageNXpɋ@\gHTMLEditorKitB
 */
public class HTMLEditorKitEx extends HTMLEditorKit{
	private boolean ese;
	
	protected Parser getParser(){ return new ParserEx(); }
	
	public boolean isEmptyStack(){ return ese; }
	
	private class ParserEx extends ParserDelegator{
	    public void parse(Reader r, HTMLEditorKit.ParserCallback cb, boolean ignoreCharSet) throws IOException {
			new DocumentParserEx(DTD.getDTD("html32")).parse(r, cb, ignoreCharSet);
	    }
	}
	
	private class DocumentParserEx extends DocumentParser{
		private HTMLDocumentEx.HTMLReaderEx reader;
		private boolean end;
		
		public DocumentParserEx(DTD dtd){ super(dtd); }
		
		public void parse(Reader in,  HTMLEditorKit.ParserCallback callback, boolean ignoreCharSet) throws IOException {
			reader	= (HTMLDocumentEx.HTMLReaderEx)callback;
			end		= false;
			ese		= false;
			super.parse(in ,callback ,ignoreCharSet);
    	}
		
		protected  void handleEndTag(TagElement tag){	// I^OoƂɌĂяo܂B
			if(end){
				ese = true;
				return;
			}
			
			if("html".equalsIgnoreCase(tag.getHTMLTag().toString()))	end = true;
			super.handleEndTag(tag);
		}
		
		protected  void handleStartTag(TagElement tag){	// Jn^OoƂɌĂяo܂B
			if(!end)	super.handleStartTag(tag);
			else		ese = true;
		}
		
		protected  void handleComment(char[] text){	// HTML ̃RgoƂɌĂяo܂B
			if(!end)	super.handleComment(text);
			else		ese = true;
		}
		
		protected  void handleEmptyTag(TagElement tag) throws ChangedCharSetException{	// ̃^OoƂɌĂяo܂B
			if(!end)	super.handleEmptyTag(tag);
			else		ese = true;
		}
		
		protected  void handleText(char[] text){	// PCDATA oƂɌĂяo܂B 
			if(!end)	super.handleText(text);
			else		ese = true;
		}
		
		protected  void handleTitle(char[] text){	// HTML  title ^OoƂɌĂяo܂B
			if(!end)	super.handleTitle(text);
			else		ese = true;
		}
	}

}
