/**
 * @(#)Hashtable2D.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/09/02
 */
package jp.co.nri.rid.web;

/* JAVA */
import	java.util.Hashtable;

/**
 * 2C[WŃL[ǗłnbVB
 */
public class Hashtable2D{
	private Hashtable myHash;
	
	public	Hashtable2D(){
		myHash = new Hashtable();
	}
	
	public synchronized void put(Object key1 ,Object key2 ,Object object){
		Hashtable hash = (Hashtable)myHash.get(key1);
		if(null==hash){
			hash = new Hashtable();
			myHash.put(key1 ,hash);
		}
		
		hash.put(key2 ,object);
	}
	
	public Object get(Object key1 ,Object key2) throws NullPointerException{
		return get(key1).get(key2);
	}
	
	public Hashtable get(Object key){
		return (Hashtable)myHash.get(key);
	}
}
