/**
 * @(#)WKeyMap.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : W Key Map
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/01/11
 * @see		elementBooster
 */
package	jp.co.nri.rid.xml;

/* java */
import	java.util.*;

/* rid */
//import	jp.co.nri.rid.xml.*;

/**
 * 2̃L[ŊǗłnbV
 */
public class WKeyMap extends HashMap{
	private	String	myKeyName1;
	private	String	myKeyName2;
	
	public WKeyMap(String keyname1 ,String keyname2 ,elementBooster[] elements){
		myKeyName1 = keyname1;
		myKeyName2 = keyname2;
		
		if(null==elements)	return;
		int mx = elements.length;
		for(int i=0;i<mx;i++)	add(elements[i]);
	}
	
	
	
//--------[[ open method ]]----------------------------------------------------
	/**
	 * Ggǉ
	 * @param	element	Gg
	 * @see		elementBooster
	 * @since	1.00
	 */
	public void add(elementBooster element){
		String key1 = element.attribute(myKeyName1);
		String key2 = element.attribute(myKeyName2);
		
		HashMap map = (HashMap)get(key1);
		if(null==map){
			map = new HashMap();
			put(key1 ,map);
		}
		map.put(key2 ,element);
	}
	
	/**
	 * Gg擾
	 * @param	key1	L[1
	 * @param	key2	L[2
	 * @return			Gg
	 * @see		elementBooster
	 * @since	1.00
	 */
	public elementBooster element(String key1 ,String key2){
		try{ return (elementBooster)((HashMap)get(key1)).get(key2); }
		catch(NullPointerException e){ return null; }
	}
}
