/**
 * @(#)RXercesXML.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : DOM Utility
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/06/12
 */
package jp.co.nri.rid.xml;

/* JAVA */
import	java.io.FileOutputStream;
import	java.io.StringWriter;
import	java.io.Reader;
import java.util.HashSet;

/* W3C DOM */
import	javax.xml.parsers.DocumentBuilderFactory;
import	javax.xml.parsers.DocumentBuilder;
import	org.xml.sax.InputSource;
import	org.w3c.dom.Node;
import	org.w3c.dom.NodeList;
import	org.w3c.dom.Document;
import	org.w3c.dom.Element;
import	org.w3c.dom.Text;
import	org.w3c.dom.DOMImplementation;
import	org.w3c.dom.DocumentType;

/* Xerces Serialize */
import	org.apache.xml.serialize.OutputFormat;
import	org.apache.xml.serialize.DOMSerializer;
import	org.apache.xml.serialize.XMLSerializer;

/**
 * DOM Utility for RID
 */
public class XercesXML{
	protected	Document	doc				=	null;
	protected	Element		rootelement		=	null;
	public		boolean		dtd_check		=	false;
	public		boolean		indent			=	true;
	public		String		defaultEncoding	=	"Shift_JIS";
	
	/**
	 * RXgN^
	 * [@\] DOMc[VKɍ쐬
	 *         EdoctB[hɐVKɍ쐬DOMc[Documentݒ
	 *         EroottB[hɐVKɍ쐬DOMc[Document
	 *           [gGgݒ
	 * @param String RootElementName [gGg("ProjrctUnit")
	 * @param String SystemID        VXeID("site.dtd")
	 */
	public XercesXML(String RootElementName ,String SystemID)
		throws
			 javax.xml.parsers.ParserConfigurationException
	{
		// hLgr_CX^X
		DocumentBuilderFactory	factory	=	DocumentBuilderFactory.newInstance();
		DocumentBuilder			builder	=	factory.newDocumentBuilder();

		// hLg^CvCX^X
		DOMImplementation	impl	=	builder.getDOMImplementation();
		DocumentType		doctype	=	impl.createDocumentType(RootElementName ,null, SystemID);
		
		// hLgCX^X
		doc	=	impl.createDocument(null ,RootElementName ,doctype);
		jp.co.iti.fagot.util.ZDebug.trace("doc class:"+doc.getClass());

		// [gGg擾
		rootelement	=	doc.getDocumentElement();
		jp.co.iti.fagot.util.ZDebug.trace("root class:"+rootelement.getClass());
	}
	
	/**
	 * RXgN^
	 * [@\] DOMc[VKɍ쐬
	 *         EdoctB[hɐVKɍ쐬DOMc[Documentݒ
	 *         EroottB[hɐVKɍ쐬DOMc[Document
	 *           [gGgݒ
	 * @param String RootElementName [gGg("ProjrctUnit")
	 * @param String PublicID        pubNID
	 * @param String SystemID        VXeID("site.dtd")
	 */
	public XercesXML(String RootElementName ,String PublicID ,String SystemID)
		throws
			 javax.xml.parsers.ParserConfigurationException
	{
		// hLgr_CX^X
		DocumentBuilderFactory	factory	=	DocumentBuilderFactory.newInstance();
		DocumentBuilder			builder	=	factory.newDocumentBuilder();

		// hLg^CvCX^X
		DOMImplementation	impl	=	builder.getDOMImplementation();
		DocumentType		doctype	=	impl.createDocumentType(RootElementName ,PublicID, SystemID);
		
		// hLgCX^X
		doc	=	impl.createDocument(null ,RootElementName ,doctype);

		// [gGg擾
		rootelement	=	doc.getDocumentElement();
	}
	
	/**
	 * RXgN^
	 * [@\] xmluriXMLt@CDOMc[쐬
	 *         EdoctB[hɍ쐬DOMc[Documentݒ
	 *         EroottB[hɍ쐬DOMc[Document
	 *           [gGgݒ
	 * @param String xmluri ǂݍXMLt@CURI
	 */
	public	XercesXML(String	xmluri)
		throws
			 javax.xml.parsers.ParserConfigurationException
			,org.xml.sax.SAXException
			,java.io.IOException
	{
		// hLgr_CX^X
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();	// ̧ؐ
		factory.setIgnoringElementContentWhitespace(true);	// sKvܲĽ͖߰߼(ɰނȂ)
		factory.setValidating(dtd_check);						// XMLص߼
		DocumentBuilder builder = factory.newDocumentBuilder();	// ޷ސ

		// hLgCX^X
		doc	=	builder.parse(xmluri);	// ߰
		jp.co.iti.fagot.util.ZDebug.trace("doc class:"+doc.getClass());

		jp.co.iti.fagot.util.ZDebug.trace("doctype:"+doc.getClass().toString());
		// [gGg擾
		rootelement	=	doc.getDocumentElement();
		jp.co.iti.fagot.util.ZDebug.trace("root class:"+rootelement.getClass());
	}
	
	/**
	 * RXgN^
	 * [@\] ReaderDOMc[쐬
	 *         EdoctB[hɍ쐬DOMc[Documentݒ
	 *         EroottB[hɍ쐬DOMc[Document
	 *           [gGgݒ
	 * @param Reader r ǂݍXMLReader(StringReader)
	 */
	public	XercesXML(Reader r)
		throws
			 javax.xml.parsers.ParserConfigurationException
			,org.xml.sax.SAXException
			,java.io.IOException
	{
		// hLgr_CX^X
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();	// ̧ؐ
		factory.setIgnoringElementContentWhitespace(true);	// sKvܲĽ͖߰߼(ɰނȂ)
		factory.setValidating(dtd_check);						// XMLص߼
		DocumentBuilder builder = factory.newDocumentBuilder();	// ޷ސ

		// hLgCX^X
		doc	=	builder.parse(new InputSource(r));	// ߰

		// [gGg擾
		rootelement	=	doc.getDocumentElement();
	}
	
	/**
	 * writeto\bh <public>
	 * [@\] DOMc[VKt@Cɏ
	 * @ret   void
	 * @param String filename VKɍ쐬XMLt@C
	 */
	public	void	writeto(String filename ,String encode)
		throws
			 java.io.FileNotFoundException
			,java.io.IOException
	{
		OutputFormat	fm	=	new OutputFormat(doc ,encode ,indent);
		
		DOMSerializer	ser	=
		new XMLSerializer(new FileOutputStream(filename),fm).asDOMSerializer();
		
		ser.serialize(doc);
	}
	
	public	void	writeto(String filename)
		throws
			 java.io.FileNotFoundException
			,java.io.IOException
	{
		writeto(filename ,defaultEncoding);
	}
	
	/**
	 * getString\bh <public>
	 * [@\] XMLt@Cւ̏o̓C[Ŵ܂ܕ񉻂B
	 * @ret   String 񉻂XMLf[^
	 * @param Ȃ
	 */
	public	String	getString()
		throws	java.io.IOException
	{
		OutputFormat	fm	=	new OutputFormat(doc ,defaultEncoding ,indent);
		
		StringWriter	sw	=	new StringWriter();
		DOMSerializer	ser	=
		new XMLSerializer(sw ,fm).asDOMSerializer();
		
		ser.serialize(doc);
		
		String	s	=	new String(sw.toString());
		sw.close();
		
		return(s);
	}
	
	/**
	 * document\bh <public>
	 * [@\] DOMc[Documentm[h߂
	 * @ret   Document DOMc[Documentm[h
	 */
	public	Document	document(){
		return(doc);
	}
	
	/**
	 * RootElement\bh <public>
	 * [@\] DOMc[̃[gGg߂
	 * @ret   Element DOMc[̃[gGg
	 */
	public	Element	RootElement(){
		return(rootelement);
	}
	
	/**
	 * createTEXTonELEMENT\bh <public>
	 * [@\] eLXgm[hGg𐶐
	 * @ret   Element ꂽGg
	 * @param String text        eLXg
	 * @param String elementname Gg
	 */
	public	Element	createTEXTonELEMENT(String text ,String elementname){
		return(createTEXTonELEMENT(text ,elementname ,doc));
	}
	
	/**
	 * createTEXTonELEMENT\bh <public static>
	 * [@\] eLXgm[hGg𐶐
	 * @ret   Element ꂽGg
	 * @param String   text        eLXg
	 * @param String   elementname Gg
	 * @param Document document    Gg𐶐hLgm[h
	 */
	public	static	Element	createTEXTonELEMENT(String text ,String elementname ,Document document){
		Element	e	=	document.createElement(elementname);
		Text	t	=	document.createTextNode(text);
		e.appendChild(t);
		
		return(e);
	}
	
	/**
	 * createELEMENTonELEMENT\bh <public>
	 * [@\] Ggm[hGg𐶐
	 * @ret   Element ꂽGg(GgB)
	 * @param String elementnameA GgBɍ쐬Gg
	 * @param String elementnameB eGg
	 */
	public	Element	createELEMENTonELEMENT(String elementnameA ,String elementnameB){
		return(createELEMENTonELEMENT(elementnameA ,elementnameB ,doc));
	}
	
	/**
	 * createELEMENTonELEMENT\bh <public static>
	 * [@\] Ggm[hGg𐶐
	 * @ret   Element ꂽGg(GgB)
	 * @param String elementnameA GgBɍ쐬Gg
	 * @param String elementnameB eGg
	 * @param Document document   Gg𐶐hLgm[h
	 */
	public	static	Element	createELEMENTonELEMENT(String elementnameA ,String elementnameB ,Document document){
		Element	B	=	document.createElement(elementnameB);
		Element	A	=	document.createElement(elementnameA);
		B.appendChild(A);
		
		return(B);
	}
	
	/**
	 * getTEXTonELEMENT\bh <public static>
	 * [@\] ^OŎqGg𓾂
	 * @ret   Element lGg
	 * @param Element parent eGg
	 * @param String  tag    ^O
	 */
	public	static	String	getTEXTonELEMENT(Element e){
		NodeList	nl = e.getChildNodes();
		
		for(int i = 0;i < nl.getLength();i++){
			Node n = nl.item(i);
			if(Node.TEXT_NODE == n.getNodeType()){
				String s = n.getNodeValue().trim();
				if(s.length() > 0)	return(s);
				return(null);
			}
		}
		
		return(null);
	}
	
	/**
	 * getChildElementByTagName\bh <public static>
	 * [@\] ^OŎqGg𓾂
	 * @ret   Element lGg
	 * @param Element parent eGg
	 * @param String  tag    ^O
	 */
	public	static	Element	getChildElementByTagName(Element parent ,String tag){
		NodeList	nl = parent.getChildNodes();
		
		for(int i = 0;i < nl.getLength();i++){
			Node n = nl.item(i);
			if(Node.ELEMENT_NODE != n.getNodeType())	continue;
			if(tag.equalsIgnoreCase(n.getNodeName()))	return((Element)n);
		}
		
		return(null);
	}
	
	/**
	 * getChildElementTextByTagName\bh <public static>
	 * [@\] ^OŎqGgPCDATA𓾂
	 * @ret   String lPCDATA
	 * @param Element parent eGg
	 * @param String  tag    ^O
	 */
	public	static	String	getChildElementTextByTagName(Element parent ,String tag){
		Element e = getChildElementByTagName(parent ,tag);
		if(null == e)	return(null);
		return(getTEXTonELEMENT(e));
	}

	
	/**
	 * getChildElementByTagName\bh <public static>
	 * [@\] ^OŎqGg𓾂
	 * @ret   Element lGg
	 * @param Element parent eGg
	 * @param String  tag    ^O
	 */
	public	static	Element	getChildElementByAttribute(Element parent ,String tag ,String attrname ,String attrstr){
		NodeList	nl = parent.getChildNodes();
		
		for(int i = 0;i < nl.getLength();i++){
			Node n = nl.item(i);
			if(Node.ELEMENT_NODE != n.getNodeType())	continue;
			if(!tag.equalsIgnoreCase(n.getNodeName()))	continue;
			
			String s = ((Element)n).getAttribute(attrname);
			if(null == s)	continue;
			if(s.equalsIgnoreCase(attrstr))	return((Element)n);
		}
		
		return(null);
	}
	
	public	static	String[]	toHashElementNames(NodeList list){
/*		
		if(null == list)	return(null);
		
		int mx = list.getLength();
		
		HashSet hs = new HashSet();
		for(int i = 0;i < mx;i++){
			Node n = list.item(i);
			if(Node.ELEMENT_NODE != n.getNodeType())	continue;
			hs.add(n.getNodeName());
		}
*/		
		HashSet hs = new HashSet();
		addHashSet(hs ,list ,null ,false);
		if(null==hs)		return(null);
		if(hs.isEmpty())	return(null);
		
/*
		Object[] objs = hs.toArray();
		String[] names = new String[objs.length];
		for(int i=0;i<names.length;i++)	names[i] = (String)objs[i];
*/		
		return(toStringArray(hs.toArray()));
	}
	
	public	static	String[]	toStringArray(Object[] objs){
		if(null==objs)	return null;
		String[] strs = new String[objs.length];
		int mx = strs.length;
		for(int i=0;i<mx;i++) strs[i] = objs[i].toString();
		
		return(strs);
	}
	
	public	static	void	addHashSet(HashSet hs ,NodeList list ,String prefix ,boolean flag){
		String SEPARATOR = "/";
		if(null == list)	return;
		
		int mx = list.getLength();
		
		for(int i = 0;i < mx;i++){
			Node n = list.item(i);
			if(Node.ELEMENT_NODE != n.getNodeType())	continue;
			String name = n.getNodeName();
			if(null!=prefix)	name = prefix + name;
			hs.add(name);
			if(flag)	addHashSet(hs ,n.getChildNodes() ,name+SEPARATOR ,flag);
		}
		
		return;
	}
	
	public	static	Element	getElementByTagName(Element e ,String name){
		if(null == e)		return(null);
		if(null == name)	return(null);
		NodeList nl = e.getElementsByTagName(name);
		
		if(null == nl)			return(null);
		if(0 >= nl.getLength())	return(null);
		return	(Element)nl.item(0);
	}
}
