/*
 * @(#)documentBooster.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : document booster
 * @author  Intelligent Technology Inc.
 * @version 1.00 2001/10/01-2001/03/25
 * @see 
 */
package	jp.co.nri.rid.xml;

/* JAVA */
import	java.io.FileOutputStream;
import	java.io.InputStream;


/* W3C DOM */
import	javax.xml.parsers.DocumentBuilderFactory;
import	javax.xml.parsers.DocumentBuilder;
import	org.w3c.dom.DOMImplementation;
import	org.w3c.dom.DocumentType;
import	org.w3c.dom.Document;
import	org.w3c.dom.Element;

/* Xerces Serialize */
import	org.apache.xml.serialize.OutputFormat;
import	org.apache.xml.serialize.DOMSerializer;
import	org.apache.xml.serialize.XMLSerializer;

import	org.xml.sax.*;

/**
 * org.w3c.dom.Documentg₷邽߂̃bp[
 */

public class documentBooster{
	protected	Document	myDocument	=	null;
	protected	boolean		dtd_check	=	false;
	protected	boolean		myIndent	=	true;
	protected	String		myEncoding	=	"Shift_JIS";
	
	protected	String		myFileName	=	null;
	
	private		DocumentBuilder myBuilder;
	
	/**
	 * xmlt@CJ
	 * @param	filename	xmlt@C
	 * @exception	javax.xml.parsers.ParserConfigurationException
	 * @since	1.00
	 */
	public	documentBooster(String filename)
		throws javax.xml.parsers.ParserConfigurationException
	{
		if(null==filename)	return;
		myFileName = filename;
		
		// hLgr_CX^X
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();	// ̧ؐ
		factory.setIgnoringElementContentWhitespace(true);	// sKvܲĽ͖߰߼(ɰނȂ)
		factory.setValidating(dtd_check);						// XMLص߼
		myBuilder = factory.newDocumentBuilder();	// ޷ސ
		
		// hLgCX^X
		
		try{ myDocument = myBuilder.parse(myFileName); }	// ߰
		catch(org.xml.sax.SAXException e){	myDocument = null; }
		catch(java.io.IOException e){		myDocument = null; }
	}
	
	/**
	 * xmlt@CJ ͐p(save()łȂ)
	 * @param		in	xmlt@C̓̓Xg[
	 * @exception	javax.xml.parsers.ParserConfigurationException
	 * @since	1.00
	 */
	public	documentBooster(InputStream in)
		throws	javax.xml.parsers.ParserConfigurationException,
				org.xml.sax.SAXException, java.io.IOException
	{
		// hLgr_CX^X
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();	// ̧ؐ
		factory.setIgnoringElementContentWhitespace(true);	// sKvܲĽ͖߰߼(ɰނȂ)
		factory.setValidating(dtd_check);						// XMLص߼
//		factory.setIgnoringComments(true);
//		factory.setExpandEntityReferences(false);
//		factory.setNamespaceAware(false);
		myBuilder = factory.newDocumentBuilder();	// ޷ސ
		
		// hLgCX^X
		myDocument = myBuilder.parse(in);	// ߰
	}
	
	/**
	 * xmlt@CJBt@CȂrootnamẽ[gGgdocumentIɐVK쐬B
	 * @param	filename	xmlt@C
	 * @param	rootname	[gGg
	 * @exception	javax.xml.parsers.ParserConfigurationException
	 * @since	1.00
	 */
	public	documentBooster(String filename ,String rootname)
		throws javax.xml.parsers.ParserConfigurationException
	{
		this(filename);
		
		if(null!=myDocument)	return;
		
		// hLg^CvCX^X
		DOMImplementation impl = myBuilder.getDOMImplementation();
//		DocumentType doctype = impl.createDocumentType(rootElementName ,PublicID ,SystemID);
		
		myDocument = impl.createDocument(null ,rootname ,null);
	}
	
	/**
	 * documentƂdocumentBoosterIuWFNg𐶐B
	 * @param	document	document
	 * @since	1.00
	 */
	public	documentBooster(Document document){ myDocument = document; }
	
	/**
	 * XMLt@CɕۑB
	 * @since	1.00
	 */
	public	void	save()
	throws
		 java.io.FileNotFoundException
		,java.io.IOException
	{ save(myFileName); }
	
	/**
	 * t@COXMLt@CɕۑB
	 * @param	filename	xmlt@C
	 * @since	1.00
	 */
	public	void	save(String filename)
	throws
		 java.io.FileNotFoundException
		,java.io.IOException
	{
		if(null==filename)	return;
		OutputFormat		fm		= new OutputFormat(myDocument ,myEncoding ,myIndent);
		FileOutputStream	stream	= new FileOutputStream(filename);
		DOMSerializer		ser		= new XMLSerializer(stream ,fm).asDOMSerializer();
		
		ser.serialize(myDocument);
	}
	
	/**
	 * Document擾B
	 * @return	DocumentIuWFNgB
	 * @since	1.00
	 */
	public Document	document(){ return myDocument; }
	
	/**
	 * [gGg擾B
	 * @return	[gGgelementBoosterIuWFNgB
	 * @since	1.00
	 */
	public elementBooster root(){ return new elementBooster(this ,myDocument.getDocumentElement()); }
}
