/**
 * @(#)SWFBitInputStream.java
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/4
 */
package	jp.co.iti.swf;

import	java.io.*;

/**
 * SWFt@CBittB[hǂނ߂̃t@CXg[B
 */
class SWFBitInputFilter{
	public	static	final	int	BYTE	=	0x01;
	public	static	final	int	WORD	=	0x02;
	
	private	SWFInputStream	myStream;
	private	int				myRest;
	private	int				myData;
	
	/**
	 * @since	1.00
	 */
	public	SWFBitInputFilter(SWFInputStream instream){
		myStream	= instream;
		myRest		= 0;
	}
	
	/**
	 * ݂̈ʒuwrbg̃f[^ǂ݂܂B
	 * f[^sꍇ͐VɃXg[1oCg̃f[^ǂ݂܂B
	 * @return	ǂݍ܂ꂽl
	 * @since	1.00
	 */
	public int read(int mode ,int bits) throws IOException{
		int value	= 0x0000;
		int backlog	= bits;
		while(true){
			if(0 >= backlog)	break;
			if(0 >= myRest){
				switch(mode){
					case	BYTE:
						myData	= myStream.readUI8();
						myRest	= 8;
						break;
					case	WORD:
						myData	= myStream.readUB16();
						myRest	= 16;
						break;
					default:
						throw new NullPointerException();
				}
			}
			
			if(backlog < myRest){
				myRest	-=	backlog;
				value	=	(value << backlog) | (myData >> myRest);
				myData	&=	(0xffff << myRest) ^ 0xffff;
				backlog	=	0;
			}else{
//			}else if(backlog > myRest){
				value	=	(value << myRest) | myData;
				myData	=	0x0000;
				backlog	-=	myRest;
				myRest	=	0;
			}
/*
			else{
				value	=	(value << backlog) | myData;
				myData	=	0x0000;
				backlog	=	0;
				myRest	=	0;
			}
*/			
		}
		
		return	value;
    }
}
