/**
 * @(#)SWFDefineButtonTag.java
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/4
 */
package	jp.co.iti.swf;

import	java.io.*;

/**
 * SWF DefineButton TAG(ID=7)\B
 */
public class SWFDefineButtonTag extends SWFTag implements hasSWFActionRecord{
	private	int					myID;
	private	SWFButtonRecords	myButtonRecords;
	private	SWFActionRecords	myActionRecords;
	
	public	SWFDefineButtonTag(int id ,byte[] data)
		throws	 SWFButtonTagException ,SWFButtonRecordsException
				,SWFActionRecordsException ,SWFActionRecordException
	{
		super(id ,data);
		myButtonRecords = new SWFButtonRecords();
		myActionRecords = new SWFActionRecords();
		
		SWFInputStream swfstream = new SWFInputStream(new ByteArrayInputStream(data));
		try{
			try{
				myID	=	swfstream.readUI16();		// Button ID
				myButtonRecords.readRecords(swfstream,false);	// Buttons
				myActionRecords.readRecords(swfstream);	// Actions
			}finally{ swfstream.close(); }
		}catch(IOException e){ throw new SWFButtonTagException(); }
	}
	
	public	SWFActionRecord[]	getActionRecords(){ return myActionRecords.getActionRecords(); }
}
