/**
 * @(#)SWFTags.java
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/4
 */
package	jp.co.iti.swf;

import	java.util.*;

/**
 * SWF TAGǗB
 */
class SWFTags{
	private	Vector	myTags;
	private int	ver;
	
	public	SWFTags(int ver){
		myTags = new Vector();
		this.ver = ver;
	}
	public	void	add(int id ,byte[] data)
		throws	 SWFActionTagException ,SWFButtonTagException ,SWFButton2TagException
				,SWFSpriteTagException ,SWFPlaceObject2TagException
				,SWFExportAssetsTagException ,SWFBodyException ,SWFImportAssetsTagException
				,SWFActionRecordsException ,SWFActionRecordException ,SWFButtonRecordsException
	{
		SWFTag tag;
		switch(id){
			case	SWFTag.DEFINEBUTTON:
				tag = new SWFDefineButtonTag(id ,data);
				break;
			case	SWFTag.ACTION:
				tag = new SWFActionTag(id ,data);
				break;
			case	SWFTag.PLACEOBJECT2:
				tag = new SWFPlaceObject2Tag(id ,data, ver);
				break;
			case	SWFTag.DEFINEBUTTON2:
				tag = new SWFDefineButton2Tag(id ,data);
				break;
			case	SWFTag.DEFINESPRITE:
				tag = new SWFDefineSpriteTag(id ,data);
				break;
			case	SWFTag.EXPORTASSETS:
				tag = new SWFExportAssetsTag(id ,data);
				break;
			case	SWFTag.IMPORTASSETS:
				tag = new SWFImportAssetsTag(id ,data);
				break;
			default:
				tag = new SWFTag(id ,data);
		}
		myTags.add(tag);
	}
	
	public	SWFTag[] getTags(){ return (SWFTag[])myTags.toArray(new SWFTag[0]); }
}
