<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty plugin
 *
 * Type:     modifier<br>
 * Name:     rkt_uri2atag<br>
 * Purpose:  URI<a>^Oň͂
 * Example:  {$text|rkt_uri2atag}
 * @version  1.0
 * @author   Yujiro Takahashi <yujiro@rakuto.net>
 * @param string
 * @return string
 */
function smarty_modifier_rkt_uri2atag($string)
{
    return preg_replace("/(https?|ftp)(:\/\/[[:alnum:]\S\+\$\?\.%,!#~*\/:@&=_-]+)/i","<a href=\"\\1\\2\" target=\"_top\">\\1\\2</a>",$string);
}

/* vim: set expandtab: */

?>
