<?php
/* ========================================================================
 - [libs/rktUpload/rkt_upload.php]
 -      画像のアップロード リサイズ機能付
 -      Copyright (c) 2004-2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 注意事項:
 -      GIF生成モジュールが使えない場合はImageGifをImagePNGに変更してください。
 - 更新履歴：
 -      [2006/06/06] イメージ処理部分をrkt_imageクラスを使用
 -      [2004/01/24] 作成
 - ======================================================================== */

require_once LIB_DIR.'rktBlob/blob_file.php';

/**
 * アップロード画像のリサイズ
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_upimage
 * @access public
 * @version 1.1
 */
class UPD_file extends BLOB_file
{
    /**
     * 一時保存ファイル名
     * @var string
     */
    var $filename;

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $dir
     * @return void
     */
    function UPD_file($dir)
    {
        $this->BLOB_file($dir);
    }

    /**
     * 画像ファイル判定
     *
     * @access public
     * @return boolean
     */
    function isImage()
    {
        /* ファイルの種類が画像か判定 */
        if (!preg_match('/image/i', $this->mime_type)){
            return false;
        }

		return true;
    }

    /**
     * ファイル名の設定
     *
     * @access public
     * @param string $filename
     * @return void
     */
    function setFilename($filename)
    {
        $this->filename = $filename;
    }

    /**
     * アップロードされた情報をメンバ変数へセットする
     *
     * @access public
     * @return boolean 成功時真
     */
    function catchFile($key)
    {
        if (!isSet($_FILES[$key])) {
            return false;
        }

        $this->origin    = md5($_FILES[$key]['tmp_name']);
        $this->name      = $_FILES[$key]['name'];
        $this->mime_type = $_FILES[$key]['type'];
        $this->size      = $_FILES[$key]['size'];

        $this->filename  = $_FILES[$key]['tmp_name'];

        return true;
    }

    /**
     * アップされた画像ファイルをコピーする
     *
     * @access public
     * @param string $filename コピーファイル名
     * @return boolean 成功時真
     */
    function saveUpfile($filename)
    {
        if (empty($this->filename)){
            return false;
        }

        $this->readfile($this->filename);
        $this->save($filename);
        
        return true;
    }

    /**
     * アップされた画像ファイルをリサイズする
     *
     * @access public
     * @param string $filename リサイズファイル名
     * @param integer $width リサイズ後の幅
     * @param integer $height リサイズ後の高さ
     * @return array 画像サイズ
     */
    function saveResize($filename, $width, $height)
    {
        $objimg = RKT_image::factory(IMAGE_DRIVER, $this->filename);
        $objimg->resize($width, $height);

        $this->buffer = $objimg->getBinary();
        $this->size = strlen($this->buffer);
        $this->save($filename);

        $infos = $objimg->getInfo();
        return array(
            'width'=>  $infos['width'],
            'height'=> $infos['height'],
        );
    }
} // UPD_file
?>