<?php
/* ========================================================================
 - [modules/private/diary/category.php]
 -      カテゴリ
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/25] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'dia_menu.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * カテゴリID
     * @var integer
     */
    var $id = null;

    /**
     * カテゴリ削除ID
     * @var integer
     */
    var $delete = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/diary/category.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->permission();
        $this->Assign('id', $this->id);
        $this->setSafety('delete');

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/diary/category/'.$this->sid.'/again/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }
        $this->set_ref_diary();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'dia_category');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            header('Location: '.HTTP_ACTION.'private/diary/category/'.$this->sid.'/complete/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/diary/category/'.$this->sid.'/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        // 一括更新
        if ($this->do_querys()){
            header('Location: '.HTTP_ACTION.'private/diary/category/'.$this->sid.'/complete/');
            exit();
        }

        // カテゴリの削除
        if ($this->delete_category()){
            header('Location: '.HTTP_ACTION.'private/diary/category/'.$this->sid.'/complete/');
            exit();
        }

        /* メニューオブジェクトの生成 */
        $objmenu = new dia_menu($this,$this->account['id']);
        $objmenu->setMenu($this->account['id']);

        $this->set_category();
    }

    /**
     * 対象IDに編集権限があるか
     *
     * @access private
     * @return void
     */
    function permission()
    {
        if (empty($this->id)){
            return ;        
        }
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_category '.
            'WHERE '.
                'id = '.$this->id.' AND '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['id'])){
            $this->id = null;        
        }
    }

    /**
     * 日記IDの取得
     *
     * @access private
     * @return interger     データ操作結果
     */
    function set_ref_diary()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_diary '.
            'WHERE '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->ref_diary = $result['id'];
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'sort,'.
                'category '.
            'FROM '.
                DB_PREFIX.'dia_category '.
            'WHERE '.
                'ref_diary = '.$this->ref_diary.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('categorys', $result);
    }

    /**
     * カテゴリ順番の取得
     *
     * @access private
     * @return interger     データ操作結果
     */
    function get_sort()
    {
        $sql=
            'SELECT '.
                'max(sort) as sort '.
            'FROM '.
                DB_PREFIX.'dia_category '.
            'WHERE '.
                'ref_diary = '.$this->ref_diary.' AND '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return empty($result['sort'])?1:$result['sort']+1;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 新規登録以外の処理
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('ref_account', $this->account['id']);
            $this->objmnp->setValue('sort', $this->get_sort());
        }

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_diary', $this->ref_diary);

        // 更新しない項目名
        $skip = array(
            'ref_account',
            'sort',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function do_querys()
    {
        if (empty($_POST['manips'])){
            return false;
        }
        foreach ($_POST['edits'] as $values){
            $this->update_query($values);
        }
        return true;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function update_query($values)
    {
        $id   = RKT_validate::number($values['id'])?$values['id']:0;
        $sort = RKT_validate::number($values['sort'])?$values['sort']:0;
        $id   = $this->objdb->quote($id);
        $sort = $this->objdb->quote($sort);

        $sql =
            'UPDATE '.
                DB_PREFIX.'dia_category '.
            'SET '.
                "modify = '".date('Y-m-d H:i:s')."',".
                'sort = '.$sort.' '.
            'WHERE '.
                'id = '.$id .' AND '.
                'ref_account = '.$this->account['id'];
        return $this->objdb->query($sql);
    }

    /**
     * カテゴリの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_category()
    {
        if (empty($this->delete)){
            return false;
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_category '.
            'WHERE '.
                'id ='.$this->delete;
        return $this->objdb->query($sql);
    }
} // webapp
?>
