<?php
/* ========================================================================
 - [modules/private/message/list.php]
 -      メッセージボックス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * ステータス
     * @var integer
     */
    var $status = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/message/list.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('status');
        $this->status = empty($this->status)?MESSAGE_INBOX:$this->status; 
        $this->Assign('status', $this->status);

        $statuses = array(
            MESSAGE_INBOX=> MESSAGE_LABEL_INBOX,
            MESSAGE_SENT=>  MESSAGE_LABEL_SENT,
            MESSAGE_DRAFT=> MESSAGE_LABEL_DRAFT,
            MESSAGE_TRASH=> MESSAGE_LABEL_TRASH,
        );
        $this->baseAssign('title', $statuses[$this->status]);
        $this->Assign('statuses', $statuses);

        $targets = array(
            MESSAGE_INBOX=> '送信者',
            MESSAGE_SENT=>  '受信者',
            MESSAGE_DRAFT=> '受信者',
            MESSAGE_TRASH=> '送信者',
        );
        $this->Assign('target', $targets[$this->status]);

        $icons = array(
            MESSAGE_FLAG_UNREAD=> 'unread',
            MESSAGE_FLAG_READ=>   'read',
            MESSAGE_FLAG_RETURN=> 'return',
        );
        $this->Assign('icons', $icons);

        /* メッセージ操作 */        
        $this->update_query();
        $this->delete_query();

        $this->set_message();
    }

    /**
     * メッセージの設定
     *
     * @access private
     * @return void
     */
    function set_message()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, 30);    // クラスの生成
        $where = 'act.id = msg.ref_from AND ';
        if ($this->status == MESSAGE_SENT || $this->status == MESSAGE_DRAFT){
            $where = 'act.id = msg.ref_to AND ';
        }
        $sql=
            'SELECT '.
                'msg.id as id,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                'msg.regist_date as regist_date,'.
                'msg.flag as flag,'.
                'msg.subject as subject '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_message msg '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                $where.
                'act.avail = '.AVAIL_ENABLE.' AND '.            
                'msg.status = '.$this->status.' AND '.
                'msg.ref_account = '.$this->account['id'] .' '.
            'ORDER BY '.
                'msg.regist_date DESC';
        $objpgr->setSql($sql);
        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $this->Assign('messages', $result);
    }

    /**
     * メッセージボックスの移動
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_query()
    {
        if (empty($_POST['manip'])){
            return ;
        }
        if (empty($_POST['msgs'])){
            return ;
        }

        $statuses = array(
            MESSAGE_INBOX,
            MESSAGE_SENT,
            MESSAGE_DRAFT,
            MESSAGE_TRASH,
        );
        $status = empty($_POST['status'])?MESSAGE_TRASH:$_POST['status'];        
        $status = in_array($status,$statuses)?$status:MESSAGE_TRASH;
        
        foreach ($_POST['msgs'] as $values){
            $this->update_message($values['id'], $status);
        }
    }

    /**
     * メッセージの更新
     *
     * @access private
     * @param integer $id
     * @param string $status
     * @return integer  データ操作結果
     */
    function update_message($id, $status)
    {
        $where = '';
        if ($status == MESSAGE_INBOX){
            $where = 'ref_to='.$this->account['id'].' AND ';
        } elseif ($status == MESSAGE_SENT || $status == MESSAGE_DRAFT) {
            $where = 'ref_from='.$this->account['id'].' AND ';
        }

        $sql =
            'UPDATE '.
                DB_PREFIX.'fri_message '.
            ' SET '.
                'status='.$status.' '.
            ' WHERE '.
                'ref_account ='.$this->account['id'].' AND '.
                $where.
                'id = '.$this->objdb->quote($id);
        $this->objdb->exec($sql);
    }

    /**
     * メッセージの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_query()
    {
        if (empty($_POST['delete'])){
            return ;
        }
        if (empty($_POST['msgs'])){
            return ;
        }
        
        foreach ($_POST['msgs'] as $values){
            $sql =
                'DELETE FROM '.
                    DB_PREFIX.'fri_message '.
                'WHERE '.
                    'id ='.$this->objdb->quote($values['id']).' AND '.
                    'ref_account ='.$this->account['id'];
            $this->objdb->exec($sql);
        }
    }
} // webapp
?>
