<?php
/* ========================================================================
 - [modules/community/bbs/list.php]
 -      トピック一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/27] ファイルパスの定数名を変更
 -      [2006/08/27] 基礎情報を親クラスから引っ張るように修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * コメント削除ID
     * @var integer
     */
    var $delete = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/bbs/list.tpl');
        $this->addJavas('common.js');

        $this->setSafety('delete');

        if ($this->delete_topic()){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->ref_community.'/');
            exit();
        }
        $this->set_topic();

        $icons = array(
            STATUS_TOPIC_BULLETIN=> 'bulletin.gif',
            STATUS_TOPIC_EVENT=> 'event.gif',
        );
        $this->Assign('icons', $icons);
    }

    /**
     * トピック一覧の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        if (!$this->community['is_member']){
            if ($this->community['visibility'] == VISIBILITY_HIDDEN){
                return ;
            }
        } // if (!$this->community['is_member'])
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_TOPIC);    // クラスの生成
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.ref_account as ref_account,'.
                'tpc.status as status,'.
                'tpc.topic as topic,'.
                'tpc.comment as comment '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'com_topic tpc '.
            'WHERE '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'tpc.ref_community = '.$this->ref_community.' '.
            'ORDER BY '.
                'tpc.modify DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $list = array();
        foreach ($result as $value){
            $list[] = array(
                'id'=> $value['id'],
                'ref_account'=> $value['ref_account'],
                'status'=> $value['status'],
                'topic'=> $value['topic'],
                'comment'=> $value['comment'],
                'pictures'=> $this->get_picture($value['id']),
                'count'=> $this->get_comment_num($value['id'])
            );
        }

        $this->Assign('list', $list);
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return array
     */
    function get_picture($ref_topic)
    {
        $sql=
            'SELECT '.
                'id,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'status = '.STATUS_PICTURE_TOPIC.' AND '.
                'ref_relation = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        return $result;
    }

    /**
     * コメント数の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return integer
     */
    function get_comment_num($ref_topic)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['ct'];
    }

    /**
     * トピックの削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_topic()
    {
        if (empty($this->delete)){
            return false;
        }
        $sql=
            'SELECT '.
                'ref_account,'.
                'status '.
            'FROM '.
                DB_PREFIX.'com_topic '.
            'WHERE '.
                'id ='.$this->delete;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (!$this->admin){
            if ($result['ref_account'] != $this->account['id']){
                return false;
            }
        } // if (!$this->admin)

        $this->delete_entry();
        $this->delete_comment();
        $this->delete_picture($this->delete, STATUS_PICTURE_TOPIC);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_topic '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'id ='.$this->delete;
        return $this->objdb->exec($sql);
    }

    /**
     * コメントの削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_comment()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'ref_topic = '.$this->delete;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        foreach ($result as $value){
            $this->delete_picture($value['id'], STATUS_PICTURE_COMMENT);
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'ref_topic = '.$this->delete;
        return $this->objdb->exec($sql);
    }

    /**
     * 添付画像の削除
     *
     * @access private
     * @return boolean
     */
    function delete_picture($ref_relation, $status)
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'status = '.$status.' AND '.
                'ref_relation = '.$ref_relation;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        include_once LIB_DIR.'rkt_blob.php';
        $objblb = RKT_blob::getInstance(BLOB_DRIVER,BLOB_PARAM);
        foreach ($result as $value){
            $objblb->unlink($value['filename']);
            $objblb->unlink($value['thumbnail']);
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'status = '.$status.' AND '.
                'ref_relation = '.$ref_relation;
        return $this->objdb->exec($sql);
    }

    /**
     * イベント参加を削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_entry()
    {
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_topic ='.$this->delete;
        return $this->objdb->exec($sql);
    }

    /****************************************************************/
    /**********    ポータルへのリクエスト処理     *******************/
    /****************************************************************/
    /**
     * ポータル用トピック・イベントデータの削除
     *
     * @access private
     * @return boolean
     */
    function request_delete($status)
    {
        include_once LIB_DIR.'PEAR/HTTP/Request.php';

        $urls = array(
            STATUS_TOPIC_BULLETIN=> 'exec/public/edit/topic/',
            STATUS_TOPIC_EVENT=>    'exec/public/edit/event/'
        );

        $req =& new HTTP_Request(WAP_HTTP_REQUEST_URL.$urls[$status]);
        $req->setMethod(HTTP_REQUEST_METHOD_POST);

        $req->addPostData('ref_sns', SNS_ID);
        $req->addPostData('community_id', $this->ref_community);
        $req->addPostData('topic_id', $this->delete);
        $req->addPostData('event_id', $this->delete);

        $req->addPostData('delete', '1');

        if (!PEAR::isError($req->sendRequest())) {
             $response = $req->getResponseBody();
        } else {
             $response = "error";
        }

        $result = false;
        if (preg_match("/<error>0<\/error>/i", $response)){
            $result = true;
        }

        return $result;
    }
} // webapp
?>
