<?php
/* ========================================================================
 - [modules/private/diary/book.php]
 -      本・印刷
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/17] do_query_select()のforach() Warning を除去
 -      [2006/09/17] PDFサポート分岐を追加
 -      [2006/09/17] system()を廃止し、include_onceで読み込みdia_book.phpを実行
 -      [2006/09/14] system()によりexecute/dia_book.phpを実行
 -      [2006/09/09] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_calendar.php';
require_once WEBAPP_LIB_DIR.'dia_menu.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 日記ID
     * @var integer
     */
    var $id = null;

    /**
     * 日記ID
     * @var integer
     */
    var $ref_diary = null;

    /**
     * 選択済みカテゴリ
     * @var integer
     */
    var $dia_bookselect = array();

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));
        if (!WAP_PDF_SUPPORT){
            header('Location: '.HTTP_ACTION.'private/diary/list/');
            exit();
        }

        $this->setTemplateFile('private/diary/book.tpl');
        
        /* URL引数の取得 */
        $this->setSafety('id');
        $this->permission();
        $this->Assign('id', $this->id);

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/diary/book/again/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }
        $this->set_ref_diary();

        // 選択済みカテゴリの取得
        $this->set_dia_bookselect();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'dia_book');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();

            // 選択済みカテゴリ処理
            $this->do_query_select();
            unset($_SESSION['dia_bookselect']);
            $_SESSION['create'] = true;

            header('Location: '.HTTP_ACTION.'private/diary/book/complete/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            $_SESSION['dia_bookselect'] = $this->dia_bookselect;
            header('Location: '.HTTP_ACTION.'private/diary/book/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }
        /* PDF作成処理 */
        $this->pdf_create();

        /* メニューオブジェクトの生成 */
        $objmenu = new dia_menu($this,$this->account['id']);
        $objmenu->setMenu($this->account['id']);

        $this->set_category();
        $this->set_date();
        $this->set_color();
        $this->set_font();
    }

    /**
     * PDFの生成
     *
     * @access public
     * @return void
     */
    function createBook($ref_book)
    {
        include_once WEBAPP_LIB_DIR.'private/dia_book.php';

        $objbook = new dia_book($ref_book);
        $objbook->execute();    
    }

    /**
     * PDF作成の設定
     *
     * @access private
     * @return void
     */
    function pdf_create()
    {
        if (empty($this->id)){
            return ;
        }
        if (preg_match('/create/i',$_SERVER['REQUEST_URI'])){
            $_SESSION['create'] = true;
            header('Location: '.HTTP_ACTION.'private/diary/book/complete/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        if (empty($_SESSION['create'])){
            return ;
        }
        unset($_SESSION['create']);
        
        $func = array('webapp','createBook');
        $this->Assign('func', $func);
        $this->Assign('create', true);

        $filename = ACTION_ARCHIVES.ARCHIVES_MEMBER_PATH.'diary_book.pdf';
        if (WAP_DB_DRIVER == 'sqlite'){
            $filename = 'cache'.WAP_ACTION_STYLE.'/diary_book.pdf';
        }

        $this->Assign('pdf_filename', $filename);
    }

    /**
     * 対象IDに編集権限があるか
     *
     * @access private
     * @return void
     */
    function permission()
    {
        if (empty($this->id)){
            return ;
        }
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_book '.
            'WHERE '.
                'id = '.$this->id.' AND '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['id'])){
            $this->id = null;        
        }
    }

    /**
     * 日記IDの取得
     *
     * @access private
     * @return interger     データ操作結果
     */
    function set_ref_diary()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_diary '.
            'WHERE '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->ref_diary = $result['id'];
    }

    /**
     * 最大最小の投稿記事の日付を取得
     *
     * @access private
     * @return void
     */
    function get_year()
    {
        $max =sql_query::dateFormat('max(regist_date)','%Y');
        $min =sql_query::dateFormat('min(regist_date)','%Y');
        $sql = 
            'SELECT '.
                $max.' as max_year,'.
                $min.' as min_year '.
            'FROM '.
                DB_PREFIX.'dia_entry '.
            'WHERE '.
                'ref_diary = '.$this->ref_diary;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result)){
            $year = date('Y', time());
            $result = array (
                'max_year'=> $year,
                'min_year'=> $year
            );
        }

        $result = array (
            'max_year'=> 2006,
            'min_year'=> 2000
        );

        $result['max_year'] = intval($result['max_year']);
        $result['min_year'] = intval($result['min_year']);

        return $result;
    }

    /**
     * 日付の設定
     *
     * @return void
     **/
    function set_date()
    {
        $timestamp  = time();

    	$years = array();
    	$months = array();
    	$days = array();

        $min_max = $this->get_year();
    	for ($num=$min_max['min_year'];$num<=$min_max['max_year'];$num++) {
    		$years[$num] = $num;
    	}
    	for ($num=1;$num<=12;$num++) {
            $num = sprintf('%02d',$num);
    		$months[$num] = $num;
    	}
    	for ($num=1;$num<=31;$num++) {
            $num = sprintf('%02d',$num);
    		$days[$num] = $num;
    	}
    	for ($num=0;$num<=23;$num++) {
            $num = sprintf('%02d',$num);
    		$hours[$num] = $num;
    	}

        $this->Assign('years', $years);
        $this->Assign('months', $months);
        $this->Assign('days', $days);

        
        $now_date = date('Y-m-d H:i:s',$timestamp);

        /* 開始年月日: */
        $date = $this->objmnp->getValue('start_date');
        $date = empty($date)?$this->objmnp->getInitValue('start_date'):$date;
        $date = empty($date)?$now_date:$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('start_date', $init_date);

        /* 終了年月日: */
        $date = $this->objmnp->getValue('end_date');
        $date = empty($date)?$this->objmnp->getInitValue('end_date'):$date;
        $date = empty($date)?$now_date:$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('end_date', $init_date);
    }

    /**
     * 色の設定
     *
     * @access private
     * @return void
     */
    function set_color()
    {
        $sql=
            'SELECT '.
                'id,'.
                'color,'.
                'rgb '.
            'FROM '.
                DB_PREFIX.'dia_color ';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value) {
            $list[$value['id']] = $value;
        }

        $this->Assign('colors', $list);
    }

    /**
     * フォントの設定
     *
     * @access private
     * @return void
     */
    function set_font()
    {
        $sql=
            'SELECT '.
                'id,'.
                'font,'.
                'label '.
            'FROM '.
                DB_PREFIX.'dia_font ';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $list = array();
        foreach ($result as $value) {
            $list[$value['id']] = $value;
        }

        $this->Assign('fonts', $list);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $this->objmnp->setCurID($this->id);

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_diary', $this->ref_diary);
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('created', 0);
        $this->objmnp->setValue('comment_flag', 0);

        // 更新しない項目名
        $skip = array(
            'ref_account',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**********************************************/
    /**********    カテゴリ     *******************/
    /**********************************************/
    /**
     * 選択したカテゴリの取得
     *
     * @access private
     * @return array
     */
    function set_dia_bookselect()
    {
        if (isSet($_POST['dia_bookselect'])){
            $this->dia_bookselect = empty($_POST['dia_bookselect'])?array():$_POST['dia_bookselect'];
            return ;
        }
        if (isSet($_SESSION['dia_bookselect'])){
            $this->dia_bookselect = empty($_SESSION['dia_bookselect'])?array():$_SESSION['dia_bookselect'];
            return ;
        }
        
        $sql=
            'SELECT '.
                'ref_category '.
            'FROM '.
                DB_PREFIX.'dia_bookselect '.
            'WHERE '.
                'ref_diary = '.$this->ref_diary.' AND '.
                'ref_book = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        
        $list = array();
        foreach ($result as $value){
            $list[$value['ref_category']] = $value['ref_category'];
        }
        
        $this->dia_bookselect = $list;
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $is_confirm = preg_match('/confirm/',$_SERVER['REQUEST_URI']);
        $sql = 
            'SELECT '.
                'cat.id as id,'.
                'count(ref.ref_category) as ct,'.
                'cat.category as category '.
            'FROM '.
                DB_PREFIX.'dia_category cat '.
                    'LEFT JOIN '.DB_PREFIX.'dia_select ref '.
                    'ON cat.id = ref.ref_category '.
            'WHERE '.
                'cat.ref_account = '.$this->account['id'].' '.
            'GROUP BY '.
                'cat.id '.
            'ORDER BY '.
                'cat.sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        if ($is_confirm){
            foreach ($result as $value){
                if (isSet($this->dia_bookselect[$value['id']])){
                    $list[] = array(
                        'id'=> $value['id'],
                        'value'=> $value['id'],
                        'count'=> $value['ct'],
                        'label'=> $value['category'],
                    );
                }
            } // foreach ($result as $value)
        } else {
            foreach ($result as $value){
                $list[] = array(
                    'id'=> $value['id'],
                    'value'=> $value['id'],
                    'count'=> $value['ct'],
                    'label'=> $value['category'],
                    'checked'=> !empty($this->dia_bookselect[$value['id']]),
                );
            }
        } // if ($this->confirm)


        $this->Assign('categorys', $list);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
    function do_query_select()
    {
        $ref_book = $this->objmnp->getCurID();
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_category '.
            'WHERE '.
                'ref_diary ='.$this->ref_diary;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return false;
        }

        foreach ($result as $value){
            if (empty($this->dia_bookselect[$value['id']])){
                $this->delete_select($value['id'], $ref_book);
            } else {
                $this->insert_select($value['id'], $ref_book);
            }
        } // foreach ($result as $value)

        return true;
    }

    /**
     * 記事のカテゴリを新規登録
     *
     * @access private
     * @param integer $ref_category  カテゴリID
     * @param integer $ref_book      本IDID
     * @return boolean  真偽値
     */
    function insert_select($ref_category, $ref_book)
    {
        $sql =
            'INSERT INTO '.
                DB_PREFIX.'dia_bookselect('.
                    'ref_diary,'.
                    'ref_category,'.
                    'ref_book'.
                ') VALUES ('.
                    $this->ref_diary.','.
                    $ref_category.','.
                    $ref_book.
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * 記事のカテゴリを削除
     *
     * @access private
     * @param integer $ref_category  カテゴリID
     * @param integer $ref_book      本ID
     * @return boolean  真偽値
     */
    function delete_select($ref_category, $ref_book)
    {
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_bookselect '.
            'WHERE '.
                'ref_diary ='.$this->ref_diary.' AND '.
                'ref_category ='.$ref_category.' AND '.
                'ref_book ='.$ref_book;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
