<?php
/* ========================================================================
 - [modules/private/show/schedule.php]
 -      スケジュール確認
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * スケジュールID
     * @var integer
     */
    var $id = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/show/schedule.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);

        /* アクション処理 */
        if (!empty($_REQUEST['update'])){
            header('Location: '.HTTP_ACTION.'private/edit/schedule/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }
        if (!empty($_REQUEST['delete'])){
            header('Location: '.HTTP_ACTION.'private/edit/schedule/'.WAP_URI_SEPARATOR.'id='.$this->id.'&delete=1');
            exit();
        }
        if (!empty($_REQUEST['back'])){
            header('Location: '.HTTP_ACTION.'private/show/calendar/');
            exit();
        }

        /* スケジュール情報 */
        if (!$this->set_schedule()){
            header('Location: '.HTTP_ACTION.'private/show/calendar/');
            exit();
        }
    }

    /**
     * スケジュールの設定
     *
     * @access private
     * @return void
     */
    function set_schedule()
    {
        $sql=
            'SELECT '.
                'id,'.
                'schedule,'.
                'start_date,'.
                'end_date,'.
                'start_hour,'.
                'start_minute,'.
                'end_hour,'.
                'end_minute,'.
                'comment,'.
                'mail_flag '.
            'FROM '.
                DB_PREFIX.'cal_schedule '.
            'WHERE '.
                'id = '.$this->id.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->Assign('value',$result);
        
        return !empty($result);
    }
} // webapp
?>
