<?php
/* ========================================================================
 - [libs/rktBLOB/blob_file.php]
 -      Binary Large OBject
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2006/11/25] 作成
 - ======================================================================== */

require_once LIB_DIR.'rktBlob/blob_common.php';

/**
 * BLOB_fileクラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_db
 * @access public
 * @version 2.0.05.1.21
 */
class BLOB_file extends BLOB_common
{
    /**
     * 基礎ディレクトリ
     * @var string
     */
    var $base_dir = '';

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $dir
     * @return void
     */
    function BLOB_file($dir='')
    {
        $this->base_dir = $dir;
    }

    /**
     * 所持バッファーの取得
     *
     * @access public
     * @return binary
     */
    function get_second($id)
    {
        $second = intval($id/1000);
        return $second.'000';
    }

    /**
     * ファイル名の実態を取得
     *
     * @access public
     * @return binary
     */
    function get_origin($filename)
    {
        $filename = str_replace('archives.php?', 'archives', $filename);
        $files = explode('/',$filename);

        $second = $this->get_second($files[2]);
        
        $origin = $files[0].DIRECTORY_SEPARATOR.$files[1].DIRECTORY_SEPARATOR.
                    $second.DIRECTORY_SEPARATOR.$files[2].DIRECTORY_SEPARATOR.
                    $files[3].DIRECTORY_SEPARATOR.$files[4];
        return $this->base_dir.$origin;
    }

    /**
     * 取得キーの変更
     *
     * @access public
     * @param string $oldname
     * @param string $newname
     * @return boolean
     */
    function rename($oldname, $newname)
    {
        $old_origin = $this->get_origin($oldname);
        if (!file_exists($old_origin)){
            return false;
        }
        $new_origin = $this->get_origin($newname);
        
        return rename($old_origin,$new_origin);
    }

    /**
     * 対象データの保存
     *
     * @access public
     * @param string $filename
     * @return boolean
     */
    function save($filename)
    {
        $this->origin = $this->get_origin($filename);

        /* ファイルの中身を取得 */
        $handle = fopen($this->origin, 'wb');
        if (!is_resource($handle)) {
            return false;
        }
        $result = fwrite($handle, $this->buffer);
        fclose($handle);
        
        return $result;
    }

    /**
     * 対象データの読み込み
     *
     * @access public
     * @param string $filename
     * @return boolean
     */
    function load($filename)
    {
        $this->origin = $this->get_origin($filename);
        $this->readfile($this->origin);

        return true;
    }

    /**
     * ファイル削除処理
     *
     * @access private
     * @param array $values
     * @return boolean
     */
    function unlink($filename)
    {
        $this->origin = $this->get_origin($filename);
        if (!file_exists($this->origin)){
            return false;
        }
        return unlink($origin);
    }

    /**
     * アーカイブディレクトリ削除処理
     *
     * @access private
     * @param array $params
     * @return boolean
     */
    function delete($params)
    {
        extract($params);
        $wheres = array();
        if (!empty($uid)){
            $dir = MEMBER_DIR.$this->get_second($uid).DIRECTORY_SEPARATOR.
                                                $uid.DIRECTORY_SEPARATOR;
            return $this->__rm_rf($dir);
        } elseif (!empty($gid)){
            $dir = COMMUNITY_DIR.$this->get_second($gid).DIRECTORY_SEPARATOR.
                                                $gid.DIRECTORY_SEPARATOR;
            return $this->__rm_rf($dir);
        }
        return false;
    }

    /**
     * 連続削除処理
     * http://go-pear.org/
     *
     * @access private
     * @param string $path
     * @return boolean
     */
    function __rm_rf($path)
    {
        if (!file_exists($path)){
            return false;
        }

        if (@is_dir($path) && is_writable($path)) {
            $dp = opendir($path);
            while ($ent = readdir($dp)) {
                if ($ent == '.' || $ent == '..') {
                    continue;
                }
                $file = $path . DIRECTORY_SEPARATOR . $ent;
                if (@is_dir($file)) {
                    $this->__rm_rf($file);
                } elseif (is_writable($file)) {
                    unlink($file);
                } else {
                    error_log($file . "is not writable and cannot be removed.Please fix the permission or select a new path.\n", 3, ERROR_LOG_FILE);
                }
            }
            closedir($dp);
            return rmdir($path);
        } else {
            return @unlink($path);
        }
    }
} // BLOB_fileの終了
?>
