<?php
/* ========================================================================
 - [libs/rkt_auth.php]
 -      ユーザー認証
 -      Copyright (c) 2004-2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2006/08/28] 自動ログイン処理修正
 -      [2006/08/28] URLの保持情報を$_SERVER['REQUEST_URI']へ修正
 -      [2006/07/21] メンバ変数にDBオブジェクトを所持
 -      [2006/04/20] lognameをemail対応に
 -      [2004/11/11] アカウントの保有を廃止 
 -                      (下位バージョンとの互換性なし)
 -      [2004/05/20] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_validate.php';
require_once RKT_INCLUDE_ACCOUNT;

/**
 * ユーザー認証クラス Context
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_auth
 * @access public
 * @version 2.0
 */
class RKT_auth
{
    /**
     * アカウントオブジェクト
     * @var object
     */
    var $account = null;

    /**
     * ログイン名
     * @var string
     */
    var $logname = '';

    /**
     * パスワード
     * @var string
     */
    var $password = '';

    /**
     * セッションID
     * @var string
     */
    var $session_id = null;

    /**
     * DBオブジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function RKT_auth($session_id=null)
    {
        $this->objdb = RKT_db::getInstance();
        $this->session_id = $session_id;

        $func = array(RKT_ACCOUNT_CLASS, 'getInstance');
        $this->account = call_user_func($func, $this->session_id);
        $this->logname = '';
        $this->password = '';
    }

    /**
     * ログイン済み認証
     * stand alone
     * @access public
     */
    function Authenticate($check,$url=null,$action=HTTP_ENTRANCE)
    {
        $func = array(RKT_ACCOUNT_CLASS, 'getInstance');
        $account = call_user_func($func);
        $status = $account->getStatus();

        RKT_auth::setCookie($account->getAccountID());

        if (empty($url)){
            $url = $action.WAP_URI_SEPARATOR.'url='.urlencode($_SERVER['REQUEST_URI']);
        }

        $result = false;
        $checks = is_array($check)?$check:array($check);
        foreach ($checks as $check){
            if ($status == $check) {
                $result = true;
                break;
            }
        } // foreach ($checks as $check)

        if (!$result) {
            header('Location: '.$url);
            exit();
        }
    }

    /**
     * パスワード用ハッシュ
     *
     * @access private
     * @param string $password
     * @return string
     */
    function passwdHash($password)
    {        
        return md5(md5($password).RKT_SEED);
    }

    /**
     * セッションIDの取得
     *
     * @access public
     * @return string セッションID
     */
    function getSessionID()
    {
        $func = array(RKT_ACCOUNT_CLASS, 'getSessionID');
        return call_user_func($func);
    }

    /**
     * ログイン
     *
     * @access public
     */
    function logIn()
    {
        $this->set_request();
        $sql=
            'SELECT '.
                'id,'.
                'password '.
            'FROM '.
                RKT_TBL_ACCOUNT.' '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                "email_hash = '".md5($this->logname)."'";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        /* 取得結果の判定 */
        if (empty($result)){
            $this->account->accountDestroy();
            return false;
        }

        /* パスワードの整合性 */
        if ($result['password'] !== $this->password){
            $this->account->accountDestroy();
            return false;
        }

        /* アカウント情報を取得できたか */
        if (!$this->account->setInfo($result['id'])){
            $this->account->accountDestroy();
            return false;
        }

        $this->account->updateLastLogin();

        return true;
    }

    /**
     * ログアウト
     *
     * @access public
     */
    function logOut()
    {
        $accounts = $this->account->getInfo();
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_autologin '.
            'WHERE '.
                'ref_account ='.$accounts['id'];
        $this->objdb->exec($sql);
        unset($_COOKIE['loginkey']);
        setcookie('loginkey', '', time()-3600, '/', WAP_COOKIE_DOMAIN);

        $this->account->accountDestroy();
    }
    
    /**
     * ユーザーリクエストを取得しメンバーへ設定
     *
     * @access private
     * @return array ユーザーリクエスト
     */
    function set_request()
    {
        // ログイン名
        if (!empty($_POST['logname'])){
            $this->logname = $_POST['logname'];
        }
        if (strlen($this->logname) > 128){
            $this->logname = '';
        }
        // ログイン名がメールの場合
        if (!RKT_validate::email($this->logname)){
            $this->logname = '';
        }

        // パスワード
        if (!empty($_POST['password'])){
            $this->password = RKT_auth::passwdHash($_POST['password']);
        }
    }

    /**
     * 自動ログイン
     *
     * @access public
     */
    function autoLogin()
    {
        if (empty($_COOKIE['loginkey'])){
            return false;
        }        

        $loginkey = $this->objdb->quote($_COOKIE['loginkey']);
        $sql=
            'SELECT '.
                'act.id as id '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_autologin aut '.
            'WHERE '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = aut.ref_account AND '.
                "aut.loginkey = '".$loginkey."'";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        /* 取得結果の判定 */
        if (empty($result)){
            setcookie('loginkey', '', time()-3600, '/', WAP_COOKIE_DOMAIN);
            $this->account->accountDestroy();
            return false;
        }

        /* アカウント情報を取得できたか */
        if (!$this->account->setInfo($result['id'])){
            setcookie('loginkey', '', time()-3600, '/', WAP_COOKIE_DOMAIN);
            $this->account->accountDestroy();
            return false;
        }

        $this->account->updateLastLogin();
        $this->setAutoLogin();

        return true;
    }
    
    /**
     * 自動ログインの設定
     *
     * @access public
     */
    function setAutoLogin()
    {
        $accounts = $this->account->getInfo();
        $loginkey = md5($infos['id'].time());
        /* 有効期限は2週間後 */
        setcookie('loginkey', $loginkey, time()+1209600, '/', WAP_COOKIE_DOMAIN);
        $_SESSION['autologin'] = true;

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_autologin '.
            'WHERE '.
                'ref_account ='.$accounts['id'];
        $this->objdb->exec($sql);

        $sql =
            'INSERT INTO '.
                DB_PREFIX.'act_autologin('.
                    'modify,'.
                    'ref_account,'.
                    'loginkey'.
                ') VALUES ('.
                    "'".date('Y-m-d H:i:s')."',".
                    $accounts['id'].','.
                    "'".$loginkey."'".
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * ユーザーエージェントIDによる自動ログイン
     *
     * @access public
     */
    function autoLoginUserAgentID()
    {
        include_once LIB_DIR.'OpenPNE/KtaiID.php';
        $ktaiID = new OpenPNE_KtaiID();
        $user_agent_id = $ktaiID->getID();

        if (empty($user_agent_id)){
            return false;
        }
        $loginkey = $this->objdb->quote($user_agent_id);
        $sql=
            'SELECT '.
                'act.id as id '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_mobilelogin aut '.
            'WHERE '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = aut.ref_account AND '.
                'aut.loginkey = '.$loginkey;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        /* 取得結果の判定 */
        if (empty($result)){
            $this->account->accountDestroy();
            return false;
        }

        /* アカウント情報を取得できたか */
        if (!$this->account->setInfo($result['id'])){
            $this->account->accountDestroy();
            return false;
        }

        $this->account->updateLastLogin();

        return true;
    }
    
    /**
     * ユーザーエージェントIDによる自動ログインの設定
     *
     * @access public
     */
    function setAutoLoginUserAgentID()
    {
        include_once LIB_DIR.'OpenPNE/KtaiID.php';
        $ktaiID = new OpenPNE_KtaiID();
        $user_agent_id = $ktaiID->getID();

        if (empty($user_agent_id)){
            return false;
        }

        $accounts = $this->account->getInfo();
        $loginkey = $this->objdb->quote($user_agent_id);

        /* 既に存在するものは削除 */
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_mobilelogin '.
            'WHERE '.
                'ref_account ='.$accounts['id'];
        $this->objdb->exec($sql);

        $sql =
            'INSERT INTO '.
                DB_PREFIX.'act_mobilelogin('.
                    'modify,'.
                    'ref_account,'.
                    'loginkey'.
                ') VALUES ('.
                    "'".date('Y-m-d H:i:s')."',".
                    $accounts['id'].','.
                    $loginkey.
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * 自動ログインキーの設定
     *
     * @access public
     */
    function setCookie($ref_account)
    {
        if (empty($_SESSION['autologin'])){
            return false;
        }
        unset($_SESSION['autologin']);
        $sql=
            'SELECT '.
                'loginkey '.
            'FROM '.
                DB_PREFIX.'act_autologin '.
            'WHERE '.
                'ref_account = '.$ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        /* 取得結果の判定 */
        if (empty($result['loginkey'])){
            setcookie('loginkey', '', time()-3600, '/', WAP_COOKIE_DOMAIN);
            return false;
        }

        /* 有効期限は2週間後 */
        setcookie('loginkey', $result['loginkey'], time()+1209600, '/', WAP_COOKIE_DOMAIN);
        return true;
    }

} // RKT_authの終了
?>
