<?php
/* ========================================================================
 - [libs/rkt_crypt.php]
 -      暗号化
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2006/07/11] 作成
 - ======================================================================== */

/**
 * 暗号化クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_crypt
 * @access public
 * @version 0.1
 */
class RKT_crypt
{
    /**
     * 暗号化オブジェクト
     * @access private
     * @var object
     */
    var $crypt = null;

    /**
     * インスタンス生成　現在の接続を返す
     *
     * @access public
     * @return object
     */
    function &getInstance($key=RKT_PASS_PHRASE)
    {
        static $__singleton;
        
        if ($__singleton == null) {
            $__singleton = new RKT_crypt($key);
        }
        return $__singleton;
    }

    /**
     * コンストラクタ
     *
     * @access public
     * @param array $request グローバルスコープ名
     */
    function RKT_crypt($key=RKT_PASS_PHRASE)
    {
        include_once LIB_DIR.'PEAR/Blowfish.php';

        $this->crypt = new Crypt_Blowfish(RKT_PASS_PHRASE);
    }

    /**
     * データの暗号化
     *
     * @access public
     * @param string $plain
     * @param string $output_func
     * @return binary 暗号化されたデータ
     */
    function encrypt($plain, $output_func='base64_encode')
    {
        $crypted = $this->crypt->encrypt($plain);
        $result = call_user_func($output_func, $crypted);

        return $result;
    }
    
    /**
     * データの復号化
     *
     * @access public
     * @param string $crypted
     * @param string $input_func
     * @return string 複合化されたデータ
     */
    function decrypt($crypted, $input_func='base64_decode')
    {
        $crypted = call_user_func($input_func, $crypted);
        $result = $this->crypt->decrypt($crypted);
        return trim($result);
    }

    /**
     * 16進数からバイナリデータへ
     *
     * @access public
     * @param  string  $hex     16進数
     * @return binary バイナリデータ
     */
    function hex2bin($hex)
    {
        $length = strlen($hex);
        return pack('H' . $length, $hex);
    }
} // RKT_crypt
?>
