<?php
/* ========================================================================
 - [modules/admin/inquire/sendmail.php]
 -      問合せ返信メール
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * メール送信ID
     * @var integer
     */
    var $id = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));
        
        $this->setTemplateFile('admin/inquire/sendmail.tpl');        

        $this->setSafety('id');
        $this->Assign('id', $this->id);

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'inq_inquire');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->sendmail();
            header('Location: '.SSL_ACTION.'admin/inquire/sendmail/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }
        
        $this->set_froms();
        $status = array(
            1 => '問合せ',
            2 => '検討中',
            3 => '対応済み'
        );
        $this->Assign('status',$status);
        $this->set_inquire();
    }

    /**
     * 送信元メールアドレス
     *
     * @access private
     * @return void
     */
    function set_froms()
    {
        $this->Assign('froms', WAP_ADMINISTRATOR);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $trigger = empty($_POST['rough'])?'manip':'rough';

        $this->objmnp->setCurID($this->id);

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_account', $this->account['id']);

        // 更新しない項目名
        $skip = array(
            'regist_date',
            'ref_account',
            'ref_category',
            'name',
            'url',
            'email',
            'comment',
        );
        $this->objmnp->catchInput($skip);

        return $this->objmnp->doManip($this,$trigger);
    }

    /**
     * 参加者へメール送信
     *
     * @access private
     * @return boolean
     **/
    function sendmail()
    {
        if (empty($_REQUEST['manip'])){
            return false;
        }

        $sql = 
            'SELECT '.
                'id,'.
                'name,'.
                'email,'.
            'FROM '.
                DB_PREFIX.'inq_inquire '.
            'WHERE '.
                'id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        if (empty($result['email'])){
            return false;
        }
        $to = sql_query::decrypt($result['email']);

    	$subject   = $this->objmnp->getValue('subject');
    	$body      = $this->objmnp->getValue('body');
    	$body     .= "\r\n";

        $objmail = new sendmail('re_inquire');
        $objmail->Assign('body', $body);
        $objmail->send($to,$subject);

        return true;
    }

    /**
     * 問合せ内容の設定
     *
     * @access private
     * @return void
     */
    function set_inquire()
    {
        $sql = 
            'SELECT '.
                'inq.id as as as id,'.
                'inq.modify as modify,'.
                'inq.regist_date as regist_date,'.
                'cat.category as as as category,'.
                'inq.status as as as status,'.
                'inq.name as as as name,'.
                'inq.url as as as url,'.
                'inq.email as email,'.
                'inq.comment as as as comment '.
            'FROM '.
                DB_PREFIX.'inq_category cat,'.
                DB_PREFIX.'inq_inquire inq '.
            'WHERE '.
                'cat.id = inq.ref_category AND '.
                'inq.id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        $this->Assign('inquire',$result);
    }
} // webapp
?>
