<?php
/* ========================================================================
 - [modules/community/bbs/topic.php]
 -      新しいトピックを作成する
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';
require_once WEBAPP_LIB_DIR.'community/pictures.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * トピックID
     * @var integer
     */
    var $id = 0;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/bbs/topic.tpl');
        $this->addJavas('common.js');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);

        /* メンバーではない */
        if (!$this->community['is_member']){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->ref_community.'/');
            exit();
        }

        /* 編集権限が無い */
        if (!$this->is_editor()){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->ref_community.'/');
            exit();
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'community/bbs/topic/'.$this->ref_community.'/again/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        // 添付画像操作クラスの生成
        $objpic = new community_pictures($this->ref_community, $this->id, STATUS_PICTURE_TOPIC);
        $objpic->doUpload();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'com_topic');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();

            /* 添付画像処理 */
            $objpic->doDelete(true);
            $objpic->setFix($this->id);
            $objpic->unSetPicture();
            
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->ref_community.'/');
            exit();
        } elseif ($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'community/bbs/topic/'.$this->ref_community.'/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        $this->Assign('picture', $objpic->getImgInfos());
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_community', $this->ref_community);
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('status', STATUS_TOPIC_BULLETIN);
        $this->objmnp->setValue('ref_prefecture', 0);
        $this->objmnp->setValue('start_date', date('Y-m-d'));

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
            'deadline',
            'start_hour',
            'start_minute',
            'local',
            'sub_locale',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * トピックの編集権限
     *
     * @access private
     * @return boolean
     */
    function is_editor()
    {
        if (empty($this->id)){
            return true;
        }
        if ($this->admin){
            return true;
        }

        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_topic '.
            'WHERE '.
                'id = '.$this->id .' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return !empty($result['ct']);
    }
} // webapp
?>
