<?php
/* ========================================================================
 - [modules/private/forum/topic.php]
 -      トピック編集
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/04] アクセス権限追加
 -      [2006/09/04] common.js読み込み
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';
require_once WEBAPP_LIB_DIR.'private/frm_pictures.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * トピックID
     * @var integer
     */
    var $id = 0;

    /**
     * データ整合性ブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * データ整合性ブジェクト
     * @var object
     */
    var $objpic = null;

    /**
     * 入力フォーム格納用
     * @var array
     */
    var $frm_select = array();

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/forum/topic.tpl');
        $this->addJavas('common.js');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->permission();
        $this->Assign('id', $this->id);
        
        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/forum/topic/again/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        // アンケート内容の取得
        $this->set_frm_select();

        // 添付画像操作クラスの生成
        $objpic = new frm_pictures($this->id, STATUS_PICTURE_TOPIC);
        $objpic->doUpload();

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'frm_topic');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();
        
            $this->do_query_select();
            unset($_SESSION['frm_select']);

            /* 添付画像処理 */
            $objpic->doDelete(true);
            $objpic->setFix($this->id);
            $objpic->unSetPicture();

            header('Location: '.HTTP_ACTION.'private/forum/list/complete/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            $_SESSION['frm_select'] = $this->frm_select;
            header('Location: '.HTTP_ACTION.'private/forum/topic/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        $this->set_prefecture();
        $this->set_sex();
        $this->set_blood();
        $this->set_married();
        $this->set_genre();

        $visibilitys = array(
            VISIBILITY_PROTECTED=> VISIBILITY_LABEL_PROTECTED,
            VISIBILITY_FRIEND=>    VISIBILITY_LABEL_FRIEND,
            VISIBILITY_HIDDEN=>    VISIBILITY_LABEL_HIDDEN,
        );
        $this->Assign('visibilitys', $visibilitys);

        $this->Assign('picture', $objpic->getImgInfos());
    }

    /**
     * 対象IDに編集権限があるか
     *
     * @access private
     * @return void
     */
    function permission()
    {
        if (empty($this->id)){
            return ;        
        }
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'id = '.$this->id.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->id = empty($result['id'])?0:$result['id'];
    }

    /**
     * 都道府県の設定
     *
     * @access private
     * @return void
     */
    function set_prefecture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'prefecture '.
            'FROM '.
                DB_PREFIX.'ara_prefecture '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['prefecture'];
        }
        
        $this->Assign('prefectures',$list);
    }

    /**
     * 性別の設定
     *
     * @access private
     * @return void
     */
    function set_sex()
    {
        $sql=
            'SELECT '.
                'id,'.
                'sex '.
            'FROM '.
                DB_PREFIX.'act_sex '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['sex'];
        }
        
        $this->Assign('sexs',$list);
    }

    /**
     * 血液型の設定
     *
     * @access private
     * @return void
     */
    function set_blood()
    {
        $sql=
            'SELECT '.
                'id,'.
                'blood '.
            'FROM '.
                DB_PREFIX.'act_blood '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['blood'];
        }
        
        $this->Assign('bloods',$list);
    }

    /**
     * 結婚についての設定
     *
     * @access private
     * @return void
     */
    function set_married()
    {
        $sql=
            'SELECT '.
                'id,'.
                'married '.
            'FROM '.
                DB_PREFIX.'act_married '.
            'ORDER BY '.
                'id';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['married'];
        }
        
        $this->Assign('marrieds',$list);
    }

    /**
     * 回答したアンケートの取得
     *
     * @access private
     * @return array
     */
    function set_frm_select()
    {
        if (isSet($_POST['frm_select'])){
            $this->frm_select = empty($_POST['frm_select'])?array():$_POST['frm_select'];
            return ;
        }
        if (isSet($_SESSION['frm_select'])){
            $this->frm_select = empty($_SESSION['frm_select'])?array():$_SESSION['frm_select'];
            return ;
        }
        if (empty($this->id)){
            return ;
        }
        
        $sql=
            'SELECT '.
                'ref_category '.
            'FROM '.
                DB_PREFIX.'frm_select '.
            'WHERE '.
                'ref_topic = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        
        $list = array();
        foreach ($result as $value){
            $list[$value['ref_category']] = $value['ref_category'];
        }
        
        $this->frm_select = $list;
    }

    /**
     * アンケートの設定
     *
     * @access private
     * @return void
     */
    function set_genre()
    {
        $sql=
            'SELECT '.
                'id,'.
                'genre '.
            'FROM '.
                DB_PREFIX.'frm_genre '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if(empty($result)){
            return ;
        }

        $list = array();
        foreach ($result as $value){
            $categorys = $this->get_category($value['id']);
            if (count($categorys)){
                $list[] = array(
                    'id'=> $value['id'],
                    'genre'=> $value['genre'],
                    'categorys'=> $categorys
                );
            }
        } // foreach ($result as $value)
        
        $this->Assign('genres',$list);
    }

    /**
     * 選択肢の設定
     *
     * @access private
     * @return void
     */
    function get_category($ref_genre)
    {
        $is_confirm = preg_match('/confirm/',$_SERVER['REQUEST_URI']);

        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'frm_category '.
            'WHERE '.
                'ref_genre = '.$ref_genre.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        $row = 0;
        $column = 0;
        if ($is_confirm){
            foreach ($result as $value){
                if (isSet($this->frm_select[$value['id']])){
                    // 改行処理
                    if ($column >= 3){
                        $column = 0;
                        $row++;
                    }
                    $list[$row][$column] = array(
                            'id'=> $value['id'],
                            'label'=> $value['category']
                    );
                    $column++;
                }
            } // foreach ($result as $value)
        } else {
            foreach ($result as $value){
                // 改行処理
                if ($column >= 3){
                    $column = 0;
                    $row++;
                }
                $list[$row][$column] = array(
                        'id'=> $value['id'],
                        'value'=> $value['id'],
                        'label'=> $value['category'],
                        'checked'=> !empty($this->frm_select[$value['id']]),
                );
                $column++;
            }
        } // if ($is_confirm)

        return $list;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        /* カレントIDの設定 */
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_account', $this->account['id']);

        $is_manip  = preg_match('/manip/',$_SERVER['REQUEST_URI']);
        if (empty($is_manip)){
            /* アンケート選択 */
            $this->objmnp->validate('number','frm_select', null, true);
        }

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
            'post',
        );
        return $this->objmnp->execute($this, $skip);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return interger     データ操作結果
     */
    function do_query_select()
    {
        $sql=
            'SELECT '.
                'cat.id as id '.
            'FROM '.
                DB_PREFIX.'frm_category cat,'.
                DB_PREFIX.'frm_genre gnr '.
            'WHERE '.
                'gnr.id = cat.ref_genre';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        foreach ($result as $value){
            if (empty($this->frm_select[$value['id']])){
                $this->delete_select($value['id']);
            } else {
                $this->insert_select($value['id']);
            }
        } // foreach ($result as $value)

        return true;
    }

    /**
     * アンケートの回答を新規登録
     *
     * @access private
     * @param integer $ref_category   選択肢ID
     * @return boolean  真偽値
     */
    function insert_select($ref_category)
    {
        $sql =
            'INSERT INTO '.
                DB_PREFIX.'frm_select('.
                    'ref_topic,'.
                    'ref_category '.
                ') VALUES ('.
                    $this->id.','.
                    $ref_category.
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * アンケートの回答を削除
     *
     * @access private
     * @param integer $ref_category   選択肢ID
     * @return boolean  真偽値
     */
    function delete_select($ref_category)
    {
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'frm_select '.
            'WHERE '.
                'ref_topic ='.$this->id.' AND '.
                'ref_category ='.$ref_category;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
