<?php
/* ========================================================================
 - [libs/rktImage/rkt_gd.php]
 -      画像処理クラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 注意事項:
 -      GIF生成モジュールが使えない場合はimageGifをimagePNGに変更してください。
 - 更新履歴：
 -      [2006/09/12] rkt_gd::convert()を追加
 -      [2006/06/04] 作成
 - ======================================================================== */

/**
 * 画像処理クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_upimage
 * @access public
 * @version 1.1
 */
class rkt_gd
{
    /**
     * 画像ファイル名
     * @var string
     */
    var $filename;

    /**
     * 画像情報
     * @var array
     */
    var $infos = array();

    /**
     * 画像リソース
     * @var resource
     */
    var $image = null;

    /**
     * リサイズ
     * @var array
     */
    var $resize = array();

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $source
     * @return void
     */
    function rkt_gd($filename=null)
    {
        if (empty($filename)){
            return ;
        }

        $this->filename = $filename;
        $this->readimage($this->filename);
    }

    /**
     * 画像情報をバッファに格納
     *
     * @access private
     * @return boolean
     */
    function readimage($filename)
    {
        $this->filename = $filename;
        if (!file_exists ($this->filename)){
            return false;
        }
        $this->set_info();

        $func = array(
            'jpg'=>  'imageCreateFromJpeg',
            'jpeg'=> 'imageCreateFromJpeg',
            'gif'=>  'imageCreateFromGif',
            'png'=>  'imageCreateFromPNG',
            'wbmp'=> 'imageCreateFromWbmp',
        );

        $this->image = @call_user_func($func[$this->infos['format']], $filename);
        
        return true;
    }

    /**
     * ファイル情報の取得
     *
     * @access private
     * @return object
     */
    function set_info()
    {
        $extensions = array(
            '1'=>'gif',
            '2'=>'jpg',
            '3'=>'png',
            '4'=>'swf',
            '5'=>'psd',
            '6'=>'bmp',
            '7'=>'tiff',
            '8'=>'tiff'
        );

        $size = getImageSize($this->filename);

        $this->infos = array(
            'type'=>   strtoupper($extensions[$size[2]]),
            'format'=> $extensions[$size[2]],
            'name'=>   basename($this->filename),
            'width'=>  $size[0],
            'height'=> $size[1],
        );
    }

    /*_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
          basic
      _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/*/

    /**
     * 対象画像のバイナリを取得
     *
     * @access public
     * @param string $filename 画像のファイル名
     * @return void
     */
    function output()
    {
        $type = $this->infos['format'];
        $type = preg_replace('/jpg/i','jpeg',$type);
    	Header('Content-Type: image/'.$type);
    	Header('Content-disposition: inline; filename='.$this->infos['name']);

        $func = array(
            'jpg'=>  'imageJpeg',
            'jpeg'=> 'imageJpeg',
            'gif'=>  'imageGif',
            'png'=>  'imagePNG',
            'wbmp'=> 'imageWbmp',
        );
        @call_user_func($func[$this->infos['format']], $this->image);
    }

    /**
     * 対象画像のリサイズ値を取得
     *
     * @access public
     * @param string $filename 画像のファイル名
     * @return boolean
     */
    function save($filename)
    {
        $func = array(
            'jpg'=>  'imageJpeg',
            'jpeg'=> 'imageJpeg',
            'gif'=>  'imageGif',
            'png'=>  'imagePNG',
            'wbmp'=> 'imageWbmp',
        );

        return @call_user_func($func[$this->infos['format']], $this->image, $filename);
    }

    /**
     * 画像情報の取得
     *
     * @access public
     * @return array 画像情報
     */
    function getInfo()
    {
        if (is_resource($this->image)){
            $this->infos['width']  = imagesx($this->image);
            $this->infos['height'] = imagesy($this->image);
        }
		return $this->infos;
    }

    /**
     * 画像バイナリデータの取得
     *
     * @access public
     * @return binary
     */
    function getBinary()
    {
        $func = array(
            'jpg'=>  'imageJpeg',
            'jpeg'=> 'imageJpeg',
            'gif'=>  'imageGif',
            'png'=>  'imagePNG',
            'wbmp'=> 'imageWbmp',
        );

		ob_start();
        @call_user_func($func[$this->infos['format']], $this->image);
		$binary = ob_get_contents();
		ob_end_clean();

        return $binary;
    }

    /**
     * 対象画像フォーマットの変換
     *
     * @access public
     * @param string $format 変換する画像フォーマット
     * @return boolean
     */
    function convert($format)
    {
        $this->infos['type'] = $format;
        $this->infos['format'] = $format;
        
        return true;
    }

    /**
     * 対象画像フォーマットの変換
     *
     * @access public
     * @param integer $width 画像の幅
     * @param integer $height 画像の高さ
     * @param string $color 背景色
     * @param string $format フォーマット
     * @return boolean
     */
    function create($width, $height, $color='white', $format='jpg')
    {
        $this->image = imageCreateTrueColor($width, $height);

        $this->infos = array(
            'type'=>   $format,
            'format'=> strtolower($format),
            'name'=>   'none.'.strtolower($format),
            'width'=>  $width,
            'height'=> $height,
        );
        
        return is_resource($this->image);
    }

    /**
     * 画像バイナリデータの設定
     *
     * @access public
     * @param binary $binary 画像バイナリデータ
     * @param string $format フォーマット
     * @return boolean
     */
    function setBinary($binary, $format)
    {
        $this->image = imageCreateFromString($binary);
        $this->infos = array(
            'type'=>   $format,
            'format'=> strtolower($format),
            'name'=>   'none.'.strtolower($format),
            'width'=>  imagesx($this->image),
            'height'=> imagesy($this->image),
        );

        return true;
    }

    /*_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
          move px
      _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/*/

    /**
     * 対象画像を切り取る
     *
     * @access public
     * @param integer $width 画像の幅
     * @param integer $height 画像の高さ
     * @param integer $x x軸の移動ピクセル
     * @param integer $y y軸の移動ピクセル
     * @return boolean
     */
    function crop($width, $height, $x=0, $y=0)
    {
        $crop = imageCreateTrueColor($width, $height);

        imageCopy($crop, $this->image, 0, 0, $x, $y, $width, $height);

        imageDestroy($this->image);
        $this->image = $crop;

        $this->infos['width']  = $width;
        $this->infos['height'] = $height;
    }

    /**
     * 対象画像のリサイズ
     *
     * @access public
     * @param integer $width 画像の幅
     * @param integer $height 画像の高さ
     * @param boolean $exactly 指定サイズを厳守
     * @return boolean
     */
    function resize($width, $height, $exactly=false)
    {
        if (!$exactly){
            $w_scale = $width/$this->infos['width'];
            $h_scale = $height/$this->infos['height'];

            /* 倍率の決定 */
            $scale = ($w_scale < $h_scale)?$w_scale:$h_scale;
    
            /* 縮小のみは以下を実行 */
            $scale = ($scale >= 1.0)?1:$scale;        
            $width  = intval($this->infos['width'] * $scale);
            $height = intval($this->infos['height'] * $scale);
        } // if (!$exactly)

        $resize = imageCreateTrueColor($width, $height);

        imageCopyResampled($resize, $this->image,
                        0, 0, 0, 0, $width, $height,
                        $this->infos['width'],$this->infos['height']);

        imageDestroy($this->image);
        $this->image = $resize;

        $this->infos['width']  = $width;
        $this->infos['height'] = $height;

        return true;
    }

    /**
     * 対象画像の回転
     *
     * @access public
     * @param integer $angle 回転角度
     * @return boolean
     */
    function rotate($angle)
    {
        $white = imageColorAllocate($this->image, 0xFF, 0xFF, 0xFF);

        $rotate = imageRotate($this->image, $angle, $white);
        imageDestroy($this->image);
        $this->image = $rotate;

        $this->infos['width']  = imagesx($this->image);
        $this->infos['height'] = imagesy($this->image);

        return true;
    }
} // rkt_gd
?>