<?php
/* ========================================================================
 - [webapp/libs/private/dia_menu.php]
 -      グループ関連の添付画像クラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/25] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_calendar.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';

/**
 * プライベート関連の添付画像クラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package dia_menu
 * @access public
 * @version 1.0
 */
class dia_menu
{
    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * カレンダーオブジェクト
     * @var object
     */
    var $objcal = null;

    /**
     * HTMLオブジェクト
     * @var object
     */
    var $objhtml = null;

    /**
     * 日記情報
     * @var array
     */
    var $diary = array();

    /**
     * 表示設定
     * @var string
     */
    var $visibility = '';

    /**
     * アカウントID
     * @var string
     */
    var $ref_account = '';

    /**
     * メニュー情報
     * @var array
     */
    var $menu = array();

    /**
     * コンストラクタ
     *
     * @access public
     * @param integer $ref_relation
     * @return void
     */
    function dia_menu(&$objhtml,$ref_account)
    {
        $this->objhtml = &$objhtml;
        $this->objdb = RKT_db::getInstance();

        /* カレンダーオブジェクトの生成 */
        $this->objcal = new RKT_calendar($this->get_date());

        $this->ref_account = $ref_account;
        $this->set_diary();
    }

    /**
     * 日付の取得
     *
     * @access public
     * @return void
     */
    function get_date()
    {
        $option = array(
            'format'=> '%Y-%n-%d'
        );
        $value = RKT_validate::getSafety('date', 'date', $option);
        return trim($this->objdb->quote($value), "'");
    }

    /**
     * 日記情報の取得
     *
     * @access private
     * @return interger     データ操作結果
     */
    function set_diary()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'dia_diary '.
            'WHERE '.
                'ref_account ='.$this->ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->diary = $result;
    }

    /**
     * コンストラクタ
     *
     * @access public
     * @param integer $audience
     * @return void
     */
    function setMenu($audience)
    {
        $this->set_audience($audience);
        $this->set_calendar();
        $this->set_days();
        $this->set_archives();
        $this->set_category();
        
        $this->objhtml->Assign('menu', $this->menu);
    }

    /**
     * 閲覧者判定の設定
     *
     * @access private
     * @param integer $audience
     * @return void
     */
    function set_audience($audience)
    {
        $visibilitys = array();
        $this->menu['target'] = 'friend';
        $this->menu['ref_friend'] = $this->ref_account;

        /* SNS内に公開 */
        $visibilitys[] = 'ent.visibility = '.VISIBILITY_PROTECTED;

        /* 閲覧者が本人 */
        if ($this->ref_account == $audience){
            $visibilitys[] = 'ent.visibility = '.VISIBILITY_HIDDEN;
            $this->menu['editor'] = true;
            $this->menu['target'] = 'private';
            $this->menu['ref_friend'] = '';
        } else {
            /* 友達に公開 */
            if ($this->objhtml->isFriend()){
                $visibilitys[] = 'ent.visibility = '.VISIBILITY_FRIEND;
            }
        } // if ($this->ref_account == $audience)

        $this->visibility = '('.implode(' OR ',$visibilitys).')';
    }    

    /**
     * カレンダーの設定
     *
     * @access private
     * @return void
     */
    function set_calendar()
    {
        $id2yobi = array(    // idから曜日に変換
            RKT_SUN => "sun",
            RKT_MON => "mon",
            RKT_TUE => "tue",
            RKT_WED => "wed",
            RKT_THU => "thu",
            RKT_FRI => "fri",
            RKT_SAT => "sat"
        );

        $id2style = array(    // idからcssクラス名に変換
            RKT_WEEKDAY => "calendar",
            RKT_HOLIDAY => "holiday",
            RKT_SATURDAY =>"saturday",
            RKT_TODAY =>   "today"
        );
        $cals   = $this->objcal->getCalendar();
        $infos  = $this->objcal->getInformation();
        $dates  = $this->objcal->getDates();
        $last   = $this->objcal->getLastday();

        $weeks = array();
        $yobi = "";
        $style = "";

        $calendars = array();
        foreach ($cals as $weekly=>$weeks){
            $cal[$weekly] = array();
            foreach ($weeks as $week=>$day){
                $style = $id2style[$infos[$weekly][$week]];
                if (!empty($this->weeks[$weekly][$week]) && !empty($day)){
                    $this->schedule[$day] = $this->weeks[$weekly][$week];
                }
        
                $calendars[$weekly]['week'][$week] = array('day'=>$day,'style'=>$style);                
            }
        } // foreach ($cals as $weekly=>$weeks)
        $this->month = sprintf('%04d-%02d',$dates[RKT_YEAR],$dates[RKT_MONTH]);

        $this->menu['calendars'] = $calendars;
        $this->menu['date'] = $dates;
        $this->menu['month'] = $dates[RKT_MONTH];
    }

    /**
     * カレンダー用記事の設定
     *
     * @access private
     * @return void
     */
    function set_days()
    {
        $dates  = $this->objcal->getDates();
        $date = sprintf('%d-%02d',$dates[RKT_YEAR],$dates[RKT_MONTH]);

        $date_format = sql_query::dateFormat('ent.regist_date','%Y-%m-%d');
        $day_format  = sql_query::dateFormat('ent.regist_date','%d');
        $month_format= sql_query::dateFormat('ent.regist_date','%Y-%m');

        $sql = 
            'SELECT '.
                $date_format.' as regist_date,'.
                $day_format.' as day,'.
                'ent.subject as subject '.
            'FROM '.
                DB_PREFIX.'dia_entry ent '.
            'WHERE '.
                'ent.ref_diary = '.$this->diary['id'].' AND '.
                $month_format." = '".$date."' AND ".
                $this->visibility.' '.
            'GROUP BY '.
                'regist_date';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        $list = array();
        foreach ($result as $value){
            $day = intval($value['day']);
            $list[$day] = array(
                'regist_date'=>$value['regist_date'],
            );
        }
        $this->menu['days'] = $list;
    }

    /**
     * アーカイブ用記事の設定
     *
     * @access private
     * @return void
     */
    function set_archives()
    {
        $date_format =sql_query::dateFormat('ent.regist_date','%Y-%m-01');
        $sql = 
            'SELECT '.
                'count(ent.id) as ct,'.
                $date_format.' as month '.
            'FROM '.
                DB_PREFIX.'dia_entry ent '.
            'WHERE '.
                'ent.ref_diary = '.$this->diary['id'].' AND '.
                $this->visibility.' '.
            'GROUP BY '.
                'month '.
            'ORDER BY '.
                'month DESC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->menu['archives'] = $result;
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql = 
            'SELECT '.
                'cat.id as id,'.
                'count(sel.ref_entry) as ct,'.
                'cat.category as category '.
            'FROM '.
                DB_PREFIX.'dia_entry ent,'.
                DB_PREFIX.'dia_category cat,'.
                DB_PREFIX.'dia_select sel '.
            'WHERE '.
                'ent.id = sel.ref_entry AND '.
                'cat.id = sel.ref_category AND '.
                'cat.ref_diary = '.$this->diary['id'].' AND '.
                $this->visibility.' '.
            'GROUP BY '.
                'cat.id '.
            'ORDER BY '.
                'cat.sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->menu['categorys'] = $result;
    }
} // dia_menuの終了
?>
