<?php
/* ========================================================================
 - [modules/friend/search/result.php]
 -      友達検索結果
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/03] 市区町村条件指定エラーの修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_crypt.php';
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * WHERE句
     * @var string
     */
    var $where = '';

    /**
     * ORDER句
     * @var string
     */
    var $order = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/search/result.tpl');

        if (!empty($_POST['search'])){
            header('Location: '.HTTP_ACTION.'friend/search/result/'.WAP_URI_SEPARATOR.http_build_query($_POST));
            exit();
        }

        $this->set_sort();
        $this->set_condition();
        $this->set_friend();
    }

    /**
     * 並び替えの設定
     *
     * @access private
     * @return void
     */
    function set_sort()
    {
        $sql=
            'SELECT '.
                'id,'.
                'label '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'ref_category = '.SORT_FRIEND.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['label'];
        }
        
        $this->Assign('sorts', $list);
    }

    /**
     * 条件データの取得
     *
     * @access private
     * @return string   絞込み句
     **/
    function get_condition()
    {
        /* 絞込条件の取得 */
        $validates = array(
            'ref_sex'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'left_age'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'right_age'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'ref_blood'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'ref_prefecture'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'local'=> array(
                'type'=> 'string',
                'option'=> array()
            ),
            'ref_hometown'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'homelocal'=> array(
                'type'=> 'string',
                'option'=> array()
            ),
            'ref_married'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'ref_item'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'ref_select'=> array(
                'type'=> 'arrayNumber',
                'option'=> array()
            ),
            'photo'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'keyword'=> array(
                'type'=> 'string',
                'option'=> array()
            ),
            'first_name'=> array(
                'type'=> 'string',
                'option'=> array()
            ),
            'second_name'=> array(
                'type'=> 'string',
                'option'=> array()
            ),
            'nickname'=> array(
                'type'=> 'string',
                'option'=> array()
            ),
            'ref_sort'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
        );

        return $this->catchCondition($validates);
    }

    /**
     * 記事リストの絞込み
     *
     * @access private
     * @return string   絞込み句
     **/
    function set_condition()
    {
        // 絞込み条件の初期化
        $where = array();
        $conditions = $this->get_condition();
        /* 性別 */
        if (!empty($conditions['ref_sex'])){
            $where[] = 'pro.ref_sex='.$conditions['ref_sex'];
        }
        /* 年齢 */
        $age = sql_query::age('pro.birthday');
        $age_flag = false;
        if (!empty($conditions['left_age'])){
            $left_age = $conditions['left_age'];
        }
        if (!empty($conditions['right_age'])){
            $right_age = $conditions['right_age'];
        }
        if (!empty($conditions['left_age']) && !empty($conditions['right_age'])){
            $left_age  = ($conditions['left_age'] < $conditions['right_age'])?$conditions['left_age']:$conditions['right_age'];
            $right_age = ($conditions['left_age'] < $conditions['right_age'])?$conditions['right_age']:$conditions['left_age'];
        }
        if (!empty($left_age)){
            $where[] = $age.' >= '.$left_age;
            $age_flag = true;
        }
        if (!empty($right_age)){
            $right_age += 1;
            $where[] = $age.' < '.$right_age;
            $age_flag = true;
        }
        if ($age_flag){
            $where[] = '(pro.age_flag='.VISIBILITY_PUBLIC.
                            ' OR pro.age_flag='.VISIBILITY_PROTECTED.')';
        }

        /* 血液型 */
        if (!empty($conditions['ref_blood'])){
            $where[] = 'pro.ref_blood='.$conditions['ref_blood'];
            $where[] = '(pro.blood_flag='.VISIBILITY_PUBLIC.
                            ' OR pro.blood_flag='.VISIBILITY_PROTECTED.')';
        }
        /* 現住所 */
        if (!empty($conditions['ref_prefecture'])){
            $where[] = 'pro.ref_prefecture='.$conditions['ref_prefecture'];
            $where[] = '(pro.prefecture_flag='.VISIBILITY_PUBLIC.
                            ' OR pro.prefecture_flag='.VISIBILITY_PROTECTED.')';
        }
        if (!empty($conditions['ref_local'])){
            $where[] = 'pro.ref_local='.$conditions['ref_local'];
        }
        /* 出身地 */
        if (!empty($conditions['ref_hometown'])){
            $where[] = 'pro.ref_hometown='.$conditions['ref_hometown'];
            $where[] = '(pro.hometown_flag='.VISIBILITY_PUBLIC.
                            ' OR pro.hometown_flag='.VISIBILITY_PROTECTED.')';
        }
        if (!empty($conditions['ref_homelocal'])){
            $where[] = 'pro.ref_homelocal='.$conditions['ref_homelocal'];
        }
        /* 未婚/既婚 */
        if (!empty($conditions['ref_married'])){
            $where[] = 'pro.ref_married='.$conditions['ref_married'];
            $where[] = '(pro.married_flag='.VISIBILITY_PUBLIC.
                            ' OR pro.married_flag='.VISIBILITY_PROTECTED.')';
        }
        /* アンケート */
        if (!empty($conditions['ref_item'])){
            if (is_array($conditions['ref_item'])){
                $where[] = 'con.ref_item in('.implode(',',$conditions['ref_item']).')';
            } else {
                $where[] = 'con.ref_item='.$conditions['ref_item'];
            }
            $where[] = '(con.visibility='.VISIBILITY_PUBLIC.
                            ' OR con.visibility='.VISIBILITY_PROTECTED.')';
        }
        $select = array();
        if (!empty($conditions['ref_select'])){
            if (is_array($conditions['ref_select'])){
                foreach ($conditions['ref_select'] as $selected){
                    $select[] = implode(',',$selected);
                }
                $where[] = 'sel.ref_item in('.implode(',',$select).')';
                $where[] = '(sel.visibility='.VISIBILITY_PUBLIC.
                                ' OR sel.visibility='.VISIBILITY_PROTECTED.')';
            }
        } // if (!empty($conditions['ref_select']))
        /* キーワード検索 */
        $keys = array();
        if (!empty($conditions['keyword'])){
            $keywords = explode(' ',$conditions['keyword']);
            foreach ($keywords as $keyword){
                $keys[] = '('.
                    "pro.nickname like '%".$keyword."%'".' OR '.
                    "pro.publicity like '%".$keyword."%'".')';
            }
            $where[] = '('.implode(' OR ',$keys) .') ';
        }
        /* 写真の有無 */
        if (!empty($conditions['photo'])){
            $where[] = 'pht.id >= 1';
        }

        /* 名        前 */
        $crypt = RKT_crypt::getInstance();
        if (!empty($conditions['first_name'])){
            $crypted = $crypt->encrypt($conditions['first_name']);
            $where[] = "pro.first_name = '".$crypted."'";
        }
        if (!empty($conditions['second_name'])){
            $crypted = $crypt->encrypt($conditions['second_name']);
            $where[] = "pro.second_name = '".$crypted."'";
        }
        /* ニックネーム */
        if (!empty($conditions['nickname'])){
            $nickname = trim($conditions['nickname']);
            $where[] = "pro.nickname like '%".$nickname."%'";
        }


        /* 並び替え */
        if (!empty($conditions['ref_sort'])){
            $this->set_order($conditions['ref_sort']);
        }

        
        if (!count($where)){
            return '';
        }
        $this->where = 'AND '. implode(' AND ',$where) .' ';
    }

    /**
     * ORDER句の設定
     *
     * @access private
     * @pram integer $id
     * @return void
     */
    function set_order($id)
    {
        $sql=
            'SELECT '.
                'direction '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->order = empty($result['direction'])?
                        '':'ORDER BY '.$result['direction'];
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_friend()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_FRIEND);    // クラスの生成
        $sql=
            'SELECT '.
                'act.id as id,'.
                'act.last_login as last_login,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'sex.sex as sex,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height,'.
                'pro.publicity as publicity '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                       'pht.status = '.STATUS_PHOTO_MAIN.' '.
                    'LEFT JOIN '.DB_PREFIX.'act_content con '.
                    'ON act.id = con.ref_account '.
                    'LEFT JOIN '.DB_PREFIX.'act_select sel '.
                    'ON act.id = sel.ref_account,'.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'sex.id = pro.ref_sex AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id != '.$this->account['id'].' '.
                $this->where.
            'GROUP BY '.
                'act.id '.
                $this->order;
        $objpgr->setSql($sql);
        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('friends', $result);
    }
} // webapp
?>
