/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDParameter
extends WSDDElement {
    OperationDesc parent;
    ParameterDesc parameter = new ParameterDesc();

    public WSDDParameter(Element e, OperationDesc parent) throws WSDDException {
        super(e);
        String typeStr;
        this.parent = parent;
        String nameStr = e.getAttribute("qname");
        if (nameStr != null && !nameStr.equals("")) {
            this.parameter.setQName(XMLUtils.getQNameFromString(nameStr, e));
        } else {
            nameStr = e.getAttribute("name");
            if (nameStr != null && !nameStr.equals("")) {
                this.parameter.setQName(new QName(null, nameStr));
            }
        }
        String modeStr = e.getAttribute("mode");
        if (modeStr != null && !modeStr.equals("")) {
            this.parameter.setMode(ParameterDesc.modeFromString(modeStr));
        }
        if ((typeStr = e.getAttribute("type")) != null && !typeStr.equals("")) {
            this.parameter.setTypeQName(XMLUtils.getQNameFromString(typeStr, e));
        }
    }

    public WSDDParameter() {
    }

    public WSDDParameter(ParameterDesc parameter) {
        this.parameter = parameter;
    }

    public void writeToContext(SerializationContext context) throws IOException {
        QName typeQName;
        byte mode;
        AttributesImpl attrs = new AttributesImpl();
        QName qname = this.parameter.getQName();
        if (qname != null) {
            if (qname.getNamespaceURI() != null && !qname.getNamespaceURI().equals("")) {
                attrs.addAttribute("", "qname", "qname", "CDATA", context.qName2String(this.parameter.getQName()));
            } else {
                attrs.addAttribute("", "name", "name", "CDATA", this.parameter.getQName().getLocalPart());
            }
        }
        if ((mode = this.parameter.getMode()) != 1) {
            String modeStr = ParameterDesc.getModeAsString(mode);
            attrs.addAttribute("", "mode", "mode", "CDATA", modeStr);
        }
        if ((typeQName = this.parameter.getTypeQName()) != null) {
            attrs.addAttribute("", "type", "type", "CDATA", context.qName2String(typeQName));
        }
        context.startElement(this.getElementName(), attrs);
        context.endElement();
    }

    public ParameterDesc getParameter() {
        return this.parameter;
    }

    public void setParameter(ParameterDesc parameter) {
        this.parameter = parameter;
    }

    protected QName getElementName() {
        return WSDDConstants.QNAME_PARAM;
    }
}

