/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class ArraySerializer
implements Serializer {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$encoding$ser$ArraySerializer == null ? (class$org$apache$axis$encoding$ser$ArraySerializer = ArraySerializer.class$("org.apache.axis.encoding.ser.ArraySerializer")) : class$org$apache$axis$encoding$ser$ArraySerializer).getName());
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$ArraySerializer;
    static /* synthetic */ Class class$java$lang$Object;

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        boolean maxOccursUsage;
        if (value == null) {
            throw new IOException(Messages.getMessage("cantDoNullArray00"));
        }
        MessageContext msgContext = context.getMessageContext();
        SchemaVersion schema = msgContext.getSchemaVersion();
        SOAPConstants soap = msgContext.getSOAPConstants();
        Class<?> cls = value.getClass();
        Collection list = null;
        if (!cls.isArray()) {
            if (!(value instanceof Collection)) {
                throw new IOException(Messages.getMessage("cantSerialize00", cls.getName()));
            }
            list = (Collection)value;
        }
        Class componentType = list == null ? cls.getComponentType() : (class$java$lang$Object == null ? (class$java$lang$Object = ArraySerializer.class$("java.lang.Object")) : class$java$lang$Object);
        String dims = "";
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
            dims = dims + "[]";
        }
        QName componentQName = context.getQNameForClass(componentType);
        if (componentQName == null) {
            Class searchCls = componentType;
            while (searchCls != null && componentQName == null) {
                searchCls = searchCls.getSuperclass();
                componentQName = context.getQNameForClass(searchCls);
            }
            if (componentQName != null) {
                componentType = searchCls;
            }
        }
        if (componentQName == null) {
            throw new IOException(Messages.getMessage("noType00", componentType.getName()));
        }
        String prefix = context.getPrefixForURI(componentQName.getNamespaceURI());
        String compType = prefix + ":" + componentQName.getLocalPart();
        int len = list == null ? Array.getLength(value) : list.size();
        String arrayType = compType + dims + "[" + len + "]";
        int dim2Len = -1;
        boolean enable2Dim = true;
        if (enable2Dim && !dims.equals("") && cls.isArray() && len > 0) {
            boolean okay = true;
            int i = 0;
            while (i < len && okay) {
                Object elementValue = Array.get(value, i);
                if (elementValue == null) {
                    okay = false;
                } else if (dim2Len < 0) {
                    dim2Len = Array.getLength(elementValue);
                    if (dim2Len <= 0) {
                        okay = false;
                    }
                } else if (dim2Len != Array.getLength(elementValue)) {
                    okay = false;
                }
                ++i;
            }
            if (okay) {
                dims = dims.substring(0, dims.length() - 2);
                arrayType = compType + dims + "[" + len + "," + dim2Len + "]";
            } else {
                dim2Len = -1;
            }
        }
        boolean bl = maxOccursUsage = !context.getMessageContext().isEncoded() && componentQName.equals(context.getCurrentXMLType());
        if (!maxOccursUsage) {
            int typeI;
            AttributesImpl attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
            if (attrs.getIndex(soap.getEncodingURI(), "arrayType") == -1) {
                String encprefix = context.getPrefixForURI(soap.getEncodingURI());
                attrs.addAttribute(soap.getEncodingURI(), "arrayType", encprefix + ":arrayType", "CDATA", arrayType);
            }
            if ((typeI = attrs.getIndex(schema.getXsiURI(), "type")) != -1) {
                String qname = context.getPrefixForURI(schema.getXsiURI(), "xsi") + ":type";
                attrs.setAttribute(typeI, schema.getXsiURI(), "type", qname, "CDATA", context.qName2String(Constants.SOAP_ARRAY));
            }
            attributes = attrs;
        }
        QName elementName = name;
        Attributes serializeAttr = attributes;
        if (!maxOccursUsage) {
            serializeAttr = null;
            context.startElement(name, attributes);
            elementName = Constants.QNAME_LITERAL_ITEM;
        }
        if (dim2Len < 0) {
            if (list == null) {
                int index = 0;
                while (index < len) {
                    Object aValue = Array.get(value, index);
                    context.serialize(elementName, serializeAttr, aValue, componentQName, true, Boolean.FALSE);
                    ++index;
                }
            } else {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object aValue = iterator.next();
                    context.serialize(elementName, serializeAttr, aValue, componentQName, true, Boolean.FALSE);
                }
            }
        } else {
            int index = 0;
            while (index < len) {
                int index2 = 0;
                while (index2 < dim2Len) {
                    Object aValue = Array.get(Array.get(value, index), index2);
                    context.serialize(elementName, null, aValue);
                    ++index2;
                }
                ++index;
            }
        }
        if (!maxOccursUsage) {
            context.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public boolean writeSchema(Types types) throws Exception {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

