/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SOAPHeaderElement
extends MessageElement
implements javax.xml.soap.SOAPHeaderElement {
    protected boolean processed = false;
    protected String actor = "";
    protected boolean mustUnderstand = false;

    public SOAPHeaderElement(String namespace, String localPart) {
        super(namespace, localPart);
    }

    public SOAPHeaderElement(Name name) {
        super(name);
    }

    public SOAPHeaderElement(String namespace, String localPart, Object value) {
        super(namespace, localPart, value);
    }

    public SOAPHeaderElement(Element elem) {
        super(elem);
        SOAP11Constants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
        String val = elem.getAttributeNS(soapConstants.getEnvelopeURI(), "mustUnderstand");
        this.mustUnderstand = val != null && val.equals("1");
        QName roleQName = soapConstants.getRoleAttributeQName();
        this.actor = elem.getAttributeNS(roleQName.getNamespaceURI(), roleQName.getLocalPart());
        if (this.actor == null) {
            this.actor = "";
        }
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        if (!(parent instanceof SOAPHeader)) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        try {
            super.setParentElement((SOAPHeader)parent);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public void detachNode() {
        ((SOAPHeader)this.parent).removeHeader(this);
        super.detachNode();
    }

    public SOAPHeaderElement(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context) {
        super(namespace, localPart, prefix, attributes, context);
        SOAP11Constants soapConstants = context.getMessageContext() == null ? SOAPConstants.SOAP11_CONSTANTS : context.getMessageContext().getSOAPConstants();
        String val = attributes.getValue(soapConstants.getEnvelopeURI(), "mustUnderstand");
        this.mustUnderstand = val != null && val.equals("1");
        QName roleQName = soapConstants.getRoleAttributeQName();
        this.actor = attributes.getValue(roleQName.getNamespaceURI(), roleQName.getLocalPart());
        if (this.actor == null) {
            this.actor = "";
        }
        this.processed = false;
    }

    public boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setMustUnderstand(boolean b) {
        this.mustUnderstand = b;
        String val = b ? "1" : "0";
        this.setAttribute("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand", val);
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String a) {
        this.actor = a;
        this.setAttribute("http://schemas.xmlsoap.org/soap/envelope/", "actor", a);
    }

    public void setProcessed(boolean value) {
        this.processed = value;
    }

    public boolean isProcessed() {
        return this.processed;
    }
}

