/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaBeanHelperWriter
extends JavaClassWriter {
    protected TypeEntry type;
    protected Vector elements;
    protected Vector attributes;
    protected TypeEntry extendType;
    protected PrintWriter wrapperPW = null;
    protected Vector elementMetaData = null;

    protected JavaBeanHelperWriter(Emitter emitter, TypeEntry type, Vector elements, TypeEntry extendType, Vector attributes) {
        super(emitter, type.getName() + "_Helper", "helper");
        this.type = type;
        this.elements = elements;
        this.attributes = attributes;
        this.extendType = extendType;
    }

    protected void setPrintWriter(PrintWriter pw) {
        this.wrapperPW = pw;
    }

    protected PrintWriter getPrintWriter(String filename) throws IOException {
        return this.wrapperPW == null ? super.getPrintWriter(filename) : this.wrapperPW;
    }

    protected void registerFile(String file) {
        if (this.wrapperPW == null) {
            super.registerFile(file);
        }
    }

    protected String verboseMessage(String file) {
        if (this.wrapperPW == null) {
            return super.verboseMessage(file);
        }
        return null;
    }

    protected void writeFileHeader(PrintWriter pw) throws IOException {
        if (this.wrapperPW == null) {
            super.writeFileHeader(pw);
        }
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        this.writeMetaData(pw);
        this.writeSerializer(pw);
        this.writeDeserializer(pw);
    }

    protected void writeFileFooter(PrintWriter pw) throws IOException {
        if (this.wrapperPW == null) {
            super.writeFileFooter(pw);
        }
    }

    protected void closePrintWriter(PrintWriter pw) {
        if (this.wrapperPW == null) {
            pw.close();
        }
    }

    protected void writeMetaData(PrintWriter pw) throws IOException {
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.size()) {
                ElementDecl elem = (ElementDecl)this.elements.get(i);
                if (this.elementMetaData == null) {
                    this.elementMetaData = new Vector();
                }
                this.elementMetaData.add(elem);
                ++i;
            }
        }
        pw.println("    // " + Messages.getMessage("typeMeta"));
        pw.println("    private static org.apache.axis.description.TypeDesc typeDesc =");
        pw.println("        new org.apache.axis.description.TypeDesc(" + Utils.getJavaLocalName(this.type.getName()) + ".class);");
        pw.println();
        if (this.attributes != null || this.elementMetaData != null) {
            boolean wroteFieldType = false;
            pw.println("    static {");
            if (this.attributes != null) {
                int i = 0;
                while (i < this.attributes.size()) {
                    TypeEntry te = (TypeEntry)this.attributes.get(i);
                    QName attrName = (QName)this.attributes.get(i + 1);
                    String attrLocalName = attrName.getLocalPart();
                    String fieldName = Utils.xmlNameToJava(attrLocalName);
                    fieldName = this.getAsFieldName(fieldName);
                    QName attrXmlType = te.getQName();
                    pw.print("        ");
                    if (!wroteFieldType) {
                        pw.print("org.apache.axis.description.FieldDesc ");
                        wroteFieldType = true;
                    }
                    pw.println("field = new org.apache.axis.description.AttributeDesc();");
                    pw.println("        field.setFieldName(\"" + fieldName + "\");");
                    pw.println("        field.setXmlName(" + Utils.getNewQName(attrName) + ");");
                    if (attrXmlType != null) {
                        pw.println("        field.setXmlType(" + Utils.getNewQName(attrXmlType) + ");");
                    }
                    pw.println("        typeDesc.addFieldDesc(field);");
                    i += 2;
                }
            }
            if (this.elementMetaData != null) {
                int i = 0;
                while (i < this.elementMetaData.size()) {
                    ElementDecl elem = (ElementDecl)this.elementMetaData.elementAt(i);
                    if (!elem.getAnyElement()) {
                        String elemLocalName = elem.getName().getLocalPart();
                        String fieldName = Utils.xmlNameToJava(elemLocalName);
                        fieldName = this.getAsFieldName(fieldName);
                        QName xmlName = elem.getName();
                        QName xmlType = elem.getType().getQName();
                        if (xmlType != null && xmlType.getLocalPart().indexOf("[") > 0) {
                            xmlType = null;
                        }
                        pw.print("        ");
                        if (!wroteFieldType) {
                            pw.print("org.apache.axis.description.FieldDesc ");
                            wroteFieldType = true;
                        }
                        pw.println("field = new org.apache.axis.description.ElementDesc();");
                        pw.println("        field.setFieldName(\"" + fieldName + "\");");
                        pw.println("        field.setXmlName(" + Utils.getNewQName(xmlName) + ");");
                        if (xmlType != null) {
                            pw.println("        field.setXmlType(" + Utils.getNewQName(xmlType) + ");");
                        }
                        if (elem.getMinOccursIs0()) {
                            pw.println("        field.setMinOccursIs0(true);");
                        }
                        pw.println("        typeDesc.addFieldDesc(field);");
                    }
                    ++i;
                }
            }
            pw.println("    };");
            pw.println();
            pw.println("    /**");
            pw.println("     * " + Messages.getMessage("returnTypeMeta"));
            pw.println("     */");
            pw.println("    public static org.apache.axis.description.TypeDesc getTypeDesc() {");
            pw.println("        return typeDesc;");
            pw.println("    }");
            pw.println();
        }
    }

    private String getAsFieldName(String fieldName) {
        if (fieldName.length() > 1 && Character.isUpperCase(fieldName.charAt(1))) {
            return Utils.capitalizeFirstChar(fieldName);
        }
        return fieldName;
    }

    protected void writeSerializer(PrintWriter pw) throws IOException {
        String typeDesc = null;
        if (this.attributes != null || this.elementMetaData != null) {
            typeDesc = "typeDesc";
        }
        String ser = " org.apache.axis.encoding.ser.BeanSerializer";
        if (this.type.isSimpleType()) {
            ser = " org.apache.axis.encoding.ser.SimpleSerializer";
        }
        pw.println("    /**");
        pw.println("     * Get Custom Serializer");
        pw.println("     */");
        pw.println("    public static org.apache.axis.encoding.Serializer getSerializer(");
        pw.println("           java.lang.String mechType, ");
        pw.println("           java.lang.Class _javaType,  ");
        pw.println("           javax.xml.namespace.QName _xmlType) {");
        pw.println("        return ");
        pw.println("          new " + ser + "(");
        pw.println("            _javaType, _xmlType, " + typeDesc + ");");
        pw.println("    }");
        pw.println();
    }

    protected void writeDeserializer(PrintWriter pw) throws IOException {
        String typeDesc = null;
        if (this.attributes != null || this.elementMetaData != null) {
            typeDesc = "typeDesc";
        }
        String dser = " org.apache.axis.encoding.ser.BeanDeserializer";
        if (this.type.isSimpleType()) {
            dser = " org.apache.axis.encoding.ser.SimpleDeserializer";
        }
        pw.println("    /**");
        pw.println("     * Get Custom Deserializer");
        pw.println("     */");
        pw.println("    public static org.apache.axis.encoding.Deserializer getDeserializer(");
        pw.println("           java.lang.String mechType, ");
        pw.println("           java.lang.Class _javaType,  ");
        pw.println("           javax.xml.namespace.QName _xmlType) {");
        pw.println("        return ");
        pw.println("          new " + dser + "(");
        pw.println("            _javaType, _xmlType, " + typeDesc + ");");
        pw.println("    }");
        pw.println();
    }
}

