/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import rumblejp.common.PropertyException;

public class Env {
    private static final String PROP_PATH_NAME = "rumblejp.properties";
    private static Properties props = null;
    public static final String PROP_DATASOURCE = "datasource";
    public static final String PROP_CHECKROBOTS_DIR = "checkrobots_dir";
    public static final String PROP_ROBOTS_DIR = "robots_dir";
    public static final String PROP_JMS_FACTORY = "jms.connectionFactory";
    public static final String PROP_DIST_HOSTNAME = "hostname";
    public static final String PROP_DIST_PASSWORD = "password";
    public static final String PROP_ENDPOINT_BATTLES = "endpoint.battles";
    public static final String PROP_ROBOTDOWNLOAD_URL = "robotdownload.url";
    public static final String PROP_SITE_HOSTNAME = "rumblejp.site";
    public static final String PROP_USERREGISTRATION_ENABLED = "user_registration.enabled";
    public static final String PROP_REGIST_ADMIN = "registration.admin";
    public static final String PROP_ROBOTREGISTRATION_ENABLED = "robot_registration.enabled";
    public static final String PROP_ROBOT_MAXSIZE = "robots.max_size";
    public static final String PROP_MAIL_RECV_URL = "mail.recv.url";
    public static final String PROP_MAIL_RECV_FOLDER = "mail.recv.folder";
    public static final String PROP_MAIL_FROM = "mail.from";

    private static void initialize() throws PropertyException {
        if (props != null) {
            return;
        }
        Properties p = new Properties();
        String path = System.getProperty(PROP_PATH_NAME);
        if (path == null || path.length() == 0) {
            throw new PropertyException(PROP_PATH_NAME);
        }
        try {
            p.load(new FileInputStream(path));
        }
        catch (IOException ex) {
            throw new PropertyException(ex);
        }
        props = p;
    }

    public static Properties getProperties() throws PropertyException {
        Env.initialize();
        return props;
    }

    public static String getString(String key) throws PropertyException {
        Env.initialize();
        String value = props.getProperty(key);
        if (value == null) {
            throw new PropertyException("Property [" + key + "] is not specified.");
        }
        return value;
    }

    public static int getInt(String key) throws PropertyException {
        Env.initialize();
        String value = props.getProperty(key);
        if (value == null) {
            throw new PropertyException("Property [" + key + "] is not specified.");
        }
        return Integer.parseInt(value);
    }
}

