/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common.beans;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class League
implements Serializable {
    public static final int BATTLE_TYPE_DUEL = 0;
    public static final int BATTLE_TYPE_MELEE = 1;
    public static final int BATTLE_TYPE_TEAM_DUEL = 2;
    public static final int BATTLE_TYPE_TEAM_MELEE = 3;
    public static String[] BATTEL_TYPE = new String[]{"1on1", "melee", "team_1on1", "team_melee"};
    private int leagueId;
    private int status;
    private int leagueType;
    private int seasonCount;
    private int divisionOpponents;
    private int groupingOpponents;
    private int rounds;
    private int adjacentRanks;
    private double coolingRate;
    private int inactivityTime;
    private int fieldWidth;
    private int fieldHeight;
    private int firstSeasonMode;
    private int lastSeason;
    private int runningSeason;
    private Date startDate = null;
    private Date finishDate = null;

    public League(ResultSet rs) throws SQLException {
        this.leagueId = rs.getInt("league_id");
        this.status = rs.getInt("status");
        this.leagueType = rs.getInt("league_type");
        this.seasonCount = rs.getInt("season_count");
        this.divisionOpponents = rs.getInt("division_opponents");
        this.groupingOpponents = rs.getInt("grouping_opponents");
        this.rounds = rs.getInt("rounds");
        this.adjacentRanks = rs.getInt("adjacent_ranks");
        this.coolingRate = rs.getFloat("cooling_rate");
        this.inactivityTime = rs.getInt("inactivity_time");
        this.fieldWidth = rs.getInt("field_width");
        this.fieldHeight = rs.getInt("field_height");
        this.firstSeasonMode = rs.getShort("first_season_mode");
        this.lastSeason = rs.getInt("last_season");
        this.runningSeason = rs.getInt("running_season");
        Timestamp t = rs.getTimestamp("start_date");
        this.startDate = new Date(t == null ? 0L : t.getTime());
        t = rs.getTimestamp("finish_date");
        this.finishDate = new Date(t == null ? 0L : t.getTime());
    }

    public int getLeagueId() {
        return this.leagueId;
    }

    public void setLeagueId(int leagueId) {
        this.leagueId = leagueId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getLeagueType() {
        return this.leagueType;
    }

    public void setLeagueType(int leagueType) {
        this.leagueType = leagueType;
    }

    public int getSeasonCount() {
        return this.seasonCount;
    }

    public void setSeasonCount(int seasonCount) {
        this.seasonCount = seasonCount;
    }

    public int getDivisionOpponents() {
        return this.divisionOpponents;
    }

    public void setDivisionOpponents(int divisionOpponents) {
        this.divisionOpponents = divisionOpponents;
    }

    public int getGroupingOpponents() {
        return this.groupingOpponents;
    }

    public void setGroupingOpponents(int groupingOpponents) {
        this.groupingOpponents = groupingOpponents;
    }

    public int getRounds() {
        return this.rounds;
    }

    public void setRounds(int rounds) {
        this.rounds = rounds;
    }

    public int getAdjacentRanks() {
        return this.adjacentRanks;
    }

    public void setAdjacentRanks(int adjacentRanks) {
        this.adjacentRanks = adjacentRanks;
    }

    public double getCoolingRate() {
        return this.coolingRate;
    }

    public void setCoolingRate(double coolingRate) {
        this.coolingRate = coolingRate;
    }

    public int getInactivityTime() {
        return this.inactivityTime;
    }

    public void setInactivityTime(int inactivityTime) {
        this.inactivityTime = inactivityTime;
    }

    public int getFieldWidth() {
        return this.fieldWidth;
    }

    public void setFieldWidth(int fieldWidth) {
        this.fieldWidth = fieldWidth;
    }

    public int getFieldHeight() {
        return this.fieldHeight;
    }

    public void setFieldHeight(int fieldHeight) {
        this.fieldHeight = fieldHeight;
    }

    public int getFirstSeasonMode() {
        return this.firstSeasonMode;
    }

    public void setFirstSeasonMode(int firstSeasonMode) {
        this.firstSeasonMode = firstSeasonMode;
    }

    public int getLastSeason() {
        return this.lastSeason;
    }

    public void setLastSeason(int lastSeason) {
        this.lastSeason = lastSeason;
    }

    public int getRunningSeason() {
        return this.runningSeason;
    }

    public void setRunningSeason(int runningSeason) {
        this.runningSeason = runningSeason;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getFinishDate() {
        return this.finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public int getBattleType() {
        if (this.groupingOpponents == 2) {
            return 0;
        }
        return 1;
    }
}

