/*
 * Decompiled with CFR 0.152.
 */
package rumblejp.common.beans;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class Machine
implements Serializable {
    private int machineId = -1;
    private int userId = -1;
    private String hostname = null;
    private long lastPosted = 0L;
    private int duelExecRounds = -1;
    private int duelTimeTotal = -1;
    private int duelTimeMax = -1;
    private int duelRecentTime = -1;
    private int meleeExecRounds = -1;
    private int meleeTimeTotal = -1;
    private int meleeTimeMax = -1;
    private int meleeRecentTime = -1;
    private int communicationCount = -1;
    private int communicationTimeTotal = -1;
    private int communicationTimeMax = -1;
    private String userLoginId = null;

    public Machine() {
    }

    public Machine(ResultSet rs) throws SQLException {
        this.machineId = rs.getInt("machine_id");
        this.userId = rs.getInt("user_id");
        this.hostname = rs.getString("hostname");
        Timestamp t = rs.getTimestamp("last_posted");
        this.lastPosted = t == null ? 0L : t.getTime();
        this.duelExecRounds = rs.getInt("duel_exec_rounds");
        this.duelTimeTotal = rs.getInt("duel_time_total");
        this.duelTimeMax = rs.getInt("duel_time_max");
        this.duelRecentTime = rs.getInt("duel_recent_time");
        this.meleeExecRounds = rs.getInt("melee_exec_rounds");
        this.meleeTimeTotal = rs.getInt("melee_time_total");
        this.meleeTimeMax = rs.getInt("melee_time_max");
        this.meleeRecentTime = rs.getInt("melee_recent_time");
        this.communicationCount = rs.getInt("communication_count");
        this.communicationTimeTotal = rs.getInt("communication_time_total");
        this.communicationTimeMax = rs.getInt("communication_time_max");
        this.userLoginId = rs.getString("login_id");
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getCommunicationTimeTotal() {
        return this.communicationTimeTotal;
    }

    public void setCommunicationTimeTotal(int communicationTimeTotal) {
        this.communicationTimeTotal = communicationTimeTotal;
    }

    public int getDuelRecentTime() {
        return this.duelRecentTime;
    }

    public void setDuelRecentTime(int duelRecentTime) {
        this.duelRecentTime = duelRecentTime;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getMeleeRecentTime() {
        return this.meleeRecentTime;
    }

    public void setMeleeRecentTime(int meleeRecentTime) {
        this.meleeRecentTime = meleeRecentTime;
    }

    public int getDuelTimeMax() {
        return this.duelTimeMax;
    }

    public void setDuelTimeMax(int duelTimeMax) {
        this.duelTimeMax = duelTimeMax;
    }

    public int getDuelTimeTotal() {
        return this.duelTimeTotal;
    }

    public void setDuelTimeTotal(int duelTimeTotal) {
        this.duelTimeTotal = duelTimeTotal;
    }

    public long getLastPosted() {
        return this.lastPosted;
    }

    public void setLastPosted(long lastPosted) {
        this.lastPosted = lastPosted;
    }

    public int getMachineId() {
        return this.machineId;
    }

    public void setMachineId(int machineId) {
        this.machineId = machineId;
    }

    public int getCommunicationTimeMax() {
        return this.communicationTimeMax;
    }

    public void setCommunicationTimeMax(int communicationTimeMax) {
        this.communicationTimeMax = communicationTimeMax;
    }

    public int getCommunicationCount() {
        return this.communicationCount;
    }

    public void setCommunicationCount(int communicationCount) {
        this.communicationCount = communicationCount;
    }

    public int getMeleeTimeTotal() {
        return this.meleeTimeTotal;
    }

    public void setMeleeTimeTotal(int meleeTimeTotal) {
        this.meleeTimeTotal = meleeTimeTotal;
    }

    public int getDuelExecRounds() {
        return this.duelExecRounds;
    }

    public void setDuelExecRounds(int duelExecRounds) {
        this.duelExecRounds = duelExecRounds;
    }

    public int getMeleeTimeMax() {
        return this.meleeTimeMax;
    }

    public void setMeleeTimeMax(int meleeTimeMax) {
        this.meleeTimeMax = meleeTimeMax;
    }

    public int getMeleeExecRounds() {
        return this.meleeExecRounds;
    }

    public void setMeleeExecRounds(int meleeExecRounds) {
        this.meleeExecRounds = meleeExecRounds;
    }

    public boolean getActive() {
        return this.lastPosted + 3600000L > System.currentTimeMillis();
    }

    public String getUserLoginId() {
        return this.userLoginId;
    }

    public void setUserLoginId(String string) {
        this.userLoginId = string;
    }

    public double getAvgDuelSeconds() {
        if (this.duelExecRounds == 0) {
            return 0.0;
        }
        return (double)this.duelTimeTotal / (double)this.duelExecRounds / 1000.0;
    }

    public double getAvgMeleeSeconds() {
        if (this.meleeExecRounds == 0) {
            return 0.0;
        }
        return (double)this.meleeTimeTotal / (double)this.meleeExecRounds / 1000.0;
    }

    public double getAvgComSeconds() {
        if (this.communicationCount == 0) {
            return 0.0;
        }
        return (double)this.communicationTimeTotal / (double)this.communicationCount / 1000.0;
    }
}

